/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class HttpHeadersFilterMixedTypeTests {
    @Test
    public void relevantDownstreamFiltersShouldActOnHeaders() {
        MockServerHttpRequest mockRequest = MockServerHttpRequest.get((String)"/get", (Object[])new Object[0]).header("header1", new String[]{"value1"}).header("header2", new String[]{"value2"}).header("header3", new String[]{"value3"}).build();
        HttpHeadersFilter filter1 = this.filterRemovingHeaders(HttpHeadersFilter.Type.RESPONSE, "header1");
        HttpHeadersFilter filter2 = this.filterRemovingHeaders(HttpHeadersFilter.Type.REQUEST, "header2");
        HttpHeaders result = HttpHeadersFilter.filterRequest(Arrays.asList(filter1, filter2), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)mockRequest));
        Assertions.assertThat((Map)result).containsOnlyKeys((Object[])new String[]{"header1", "header3"});
    }

    private HttpHeadersFilter filterRemovingHeaders(final HttpHeadersFilter.Type type, String ... headerNames) {
        final HashSet<String> headerNamesSet = new HashSet<String>(Arrays.asList(headerNames));
        HttpHeadersFilter filter = new HttpHeadersFilter(){

            public HttpHeaders filter(HttpHeaders headers, ServerWebExchange exchange) {
                HttpHeaders result = new HttpHeaders();
                headers.entrySet().forEach(entry -> {
                    if (!headerNamesSet.contains(entry.getKey())) {
                        result.put((String)entry.getKey(), (List)entry.getValue());
                    }
                });
                return result;
            }

            public boolean supports(HttpHeadersFilter.Type path) {
                return path.equals((Object)type);
            }
        };
        return filter;
    }
}

