/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class HttpHeadersFilterTests {
    @Test
    public void httpHeadersFilterTests() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost:8080/get", (Object[])new Object[0]).header("X-A", new String[]{"aValue"}).header("X-B", new String[]{"bValue"}).header("X-C", new String[]{"cValue"}).build();
        List<HttpHeadersFilter> filters = Arrays.asList((h, e) -> this.filter(h, "X-A"), (h, e) -> this.filter(h, "X-B"));
        HttpHeaders headers = HttpHeadersFilter.filterRequest(filters, (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((Map)headers).containsOnlyKeys((Object[])new String[]{"X-C"});
    }

    private HttpHeaders filter(HttpHeaders input, String keyToFilter) {
        HttpHeaders filtered = new HttpHeaders();
        input.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(keyToFilter)).forEach(entry -> filtered.addAll((String)entry.getKey(), (List)entry.getValue()));
        return filtered;
    }
}

