/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class AsyncPredicateTest {
    @Test
    public void andPredicateShouldNotTestRightOperatorIfLeftOperatorIsFalse() {
        TestAsyncPredicate left = new TestAsyncPredicate(o -> false);
        TestAsyncPredicate right = new TestAsyncPredicate(o -> true);
        Publisher andTest = (Publisher)left.and(right).apply(new Object());
        StepVerifier.create((Publisher)andTest).expectNext((Object)false).expectComplete().verify();
        left.assertTested();
        right.assertUntested();
    }

    @Test
    public void andPredicateShouldTestRightOperatorIfLeftOperatorIsTrue() {
        TestAsyncPredicate left = new TestAsyncPredicate(o -> true);
        TestAsyncPredicate right = new TestAsyncPredicate(o -> false);
        Publisher andTest = (Publisher)left.and(right).apply(new Object());
        StepVerifier.create((Publisher)andTest).expectNext((Object)false).expectComplete().verify();
        left.assertTested();
        right.assertTested();
    }

    @Test
    public void orPredicateShouldNotTestRightOperatorIfLeftOperatorIsTrue() {
        TestAsyncPredicate left = new TestAsyncPredicate(o -> true);
        TestAsyncPredicate right = new TestAsyncPredicate(o -> false);
        Publisher orTest = (Publisher)left.or(right).apply(new Object());
        StepVerifier.create((Publisher)orTest).expectNext((Object)true).expectComplete().verify();
        left.assertTested();
        right.assertUntested();
    }

    @Test
    public void orPredicateShouldTestRightOperatorIfLeftOperatorIsFalse() {
        TestAsyncPredicate left = new TestAsyncPredicate(o -> false);
        TestAsyncPredicate right = new TestAsyncPredicate(o -> true);
        Publisher orTest = (Publisher)left.or(right).apply(new Object());
        StepVerifier.create((Publisher)orTest).expectNext((Object)true).expectComplete().verify();
        left.assertTested();
        right.assertTested();
    }

    @Test
    public void negateOperatorWorks() {
        TestAsyncPredicate falsePredicate = new TestAsyncPredicate(o -> false);
        TestAsyncPredicate truePredicate = new TestAsyncPredicate(o -> true);
        Publisher falseNot = (Publisher)falsePredicate.negate().apply(new Object());
        Publisher trueNot = (Publisher)truePredicate.negate().apply(new Object());
        StepVerifier.create((Publisher)falseNot).expectNext((Object)true).expectComplete().verify();
        StepVerifier.create((Publisher)trueNot).expectNext((Object)false).expectComplete().verify();
        falsePredicate.assertTested();
        truePredicate.assertTested();
    }

    private static final class TestAsyncPredicate<T>
    implements AsyncPredicate<T> {
        private final Predicate<T> delegate;
        private boolean tested = false;

        private TestAsyncPredicate(Predicate<T> predicate) {
            this.delegate = predicate;
        }

        public Publisher<Boolean> apply(T t) {
            this.tested = true;
            return Mono.just((Object)this.delegate.test(t));
        }

        public void assertTested() {
            Assert.assertTrue((String)"predicate must have been tested", (boolean)this.tested);
        }

        public void assertUntested() {
            Assert.assertFalse((String)"predicate must not have been tested", (boolean)this.tested);
        }
    }
}

