/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Arrays;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.gateway.handler.predicate.HostRoutePredicateFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class HostRoutePredicateFactoryTests
extends BaseWebClientTests {
    @Test
    public void hostRouteWorks() {
        this.expectHostRoute("www.example.org", "host_example_to_httpbin");
    }

    public void expectHostRoute(String host, String routeId) {
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{host}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{routeId});
    }

    @Test
    public void hostRouteBackwardsCompatiblePatternWorks() {
        this.expectHostRoute("www.hostpatternarg.org", "host_backwards_compatible_test");
    }

    @Test
    public void hostRouteBackwardsCompatibleShortcutWorks() {
        this.expectHostRoute("www.hostpatternshortcut.org", "host_backwards_compatible_shortcut_test");
    }

    @Test
    public void mulitHostRouteWorks() {
        this.expectHostRoute("www.hostmulti1.org", "host_multi_test");
        this.expectHostRoute("www.hostmulti2.org", "host_multi_test");
    }

    @Test
    public void mulitHostRouteDslWorks() {
        this.expectHostRoute("www.hostmultidsl1.org", "host_multi_dsl");
        this.expectHostRoute("www.hostmultidsl2.org", "host_multi_dsl");
    }

    @Test
    public void toStringFormat() {
        HostRoutePredicateFactory.Config config = new HostRoutePredicateFactory.Config().setPatterns(Arrays.asList("pattern1", "pattern2"));
        Predicate predicate = new HostRoutePredicateFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"pattern1"})).contains(new CharSequence[]{"pattern2"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("host_multi_dsl", r -> r.host(new String[]{"**.hostmultidsl1.org", "**.hostmultidsl2.org"}).filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).build();
        }
    }
}

