/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.config.PropertiesRouteDefinitionLocator;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.OrderedGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RetryGatewayFilterFactory;
import org.springframework.cloud.gateway.handler.predicate.HostRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.handler.predicate.RoutePredicateFactory;
import org.springframework.cloud.gateway.route.CompositeRouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinitionRouteLocator;
import org.springframework.cloud.gateway.support.ConfigurationService;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.test.StepVerifier;

public class RouteDefinitionRouteLocatorTests {
    @Test
    public void contextLoads() {
        List<RoutePredicateFactory> predicates = Arrays.asList(new HostRoutePredicateFactory());
        List<GatewayFilterFactory> gatewayFilterFactories = Arrays.asList(new GatewayFilterFactory[]{new RemoveResponseHeaderGatewayFilterFactory(), new AddResponseHeaderGatewayFilterFactory(), new TestOrderedGatewayFilterFactory()});
        GatewayProperties gatewayProperties = new GatewayProperties();
        gatewayProperties.setRoutes(Arrays.asList(new RouteDefinition(){
            {
                this.setId("foo");
                this.setUri(URI.create("https://foo.example.com"));
                this.setPredicates(Arrays.asList(new PredicateDefinition("Host=*.example.com")));
                this.setFilters(Arrays.asList(new FilterDefinition("RemoveResponseHeader=Server"), new FilterDefinition("TestOrdered="), new FilterDefinition("AddResponseHeader=X-Response-Foo, Bar")));
            }
        }));
        PropertiesRouteDefinitionLocator routeDefinitionLocator = new PropertiesRouteDefinitionLocator(gatewayProperties);
        RouteDefinitionRouteLocator routeDefinitionRouteLocator = new RouteDefinitionRouteLocator((RouteDefinitionLocator)new CompositeRouteDefinitionLocator(Flux.just((Object)routeDefinitionLocator)), predicates, gatewayFilterFactories, gatewayProperties, new ConfigurationService(null, () -> null, () -> null));
        StepVerifier.create((Publisher)routeDefinitionRouteLocator.getRoutes()).assertNext(route -> {
            List filters = route.getFilters();
            Assertions.assertThat((List)filters).hasSize(3);
            Assertions.assertThat((String)this.getFilterClassName((GatewayFilter)filters.get(0))).contains(new CharSequence[]{"RemoveResponseHeader"});
            Assertions.assertThat((String)this.getFilterClassName((GatewayFilter)filters.get(1))).contains(new CharSequence[]{"AddResponseHeader"});
            Assertions.assertThat((String)this.getFilterClassName((GatewayFilter)filters.get(2))).contains(new CharSequence[]{"RouteDefinitionRouteLocatorTests$TestOrderedGateway"});
        }).expectComplete().verify();
    }

    @Test
    public void simpleRetryDefinitionLoads() {
        List<RoutePredicateFactory> predicates = Arrays.asList(new HostRoutePredicateFactory());
        List<GatewayFilterFactory> gatewayFilterFactories = Arrays.asList(new RetryGatewayFilterFactory());
        GatewayProperties gatewayProperties = new GatewayProperties();
        gatewayProperties.setRoutes(Arrays.asList(new RouteDefinition(){
            {
                this.setId("simple");
                this.setUri(URI.create("https://foo.example.com"));
                this.setPredicates(Arrays.asList(new PredicateDefinition("Host=*.example.com")));
                this.setFilters(Arrays.asList(new FilterDefinition("Retry=3,INTERNAL_SERVER_ERROR,GET")));
            }
        }));
        PropertiesRouteDefinitionLocator routeDefinitionLocator = new PropertiesRouteDefinitionLocator(gatewayProperties);
        RouteDefinitionRouteLocator routeDefinitionRouteLocator = new RouteDefinitionRouteLocator((RouteDefinitionLocator)new CompositeRouteDefinitionLocator(Flux.just((Object)routeDefinitionLocator)), predicates, gatewayFilterFactories, gatewayProperties, new ConfigurationService(null, () -> null, () -> null));
        StepVerifier.create((Publisher)routeDefinitionRouteLocator.getRoutes()).assertNext(route -> {
            List filters = route.getFilters();
            Assertions.assertThat((List)filters).hasSize(1);
            Assertions.assertThat((String)this.getFilterClassName((GatewayFilter)filters.get(0))).contains(new CharSequence[]{"Retry"});
            Assertions.assertThat((String)((GatewayFilter)filters.get(0)).toString()).contains(new CharSequence[]{"retries = 3"});
            Assertions.assertThat((String)((GatewayFilter)filters.get(0)).toString()).contains(new CharSequence[]{"series = list[SERVER_ERROR]"});
            Assertions.assertThat((String)((GatewayFilter)filters.get(0)).toString()).contains(new CharSequence[]{"methods = list[GET]"});
        }).expectComplete().verify();
    }

    @Test
    public void contextLoadsWithErrorRecovery() {
        List<RoutePredicateFactory> predicates = Arrays.asList(new HostRoutePredicateFactory());
        List<GatewayFilterFactory> gatewayFilterFactories = Arrays.asList(new GatewayFilterFactory[]{new RemoveResponseHeaderGatewayFilterFactory(), new AddResponseHeaderGatewayFilterFactory(), new TestOrderedGatewayFilterFactory()});
        GatewayProperties gatewayProperties = new GatewayProperties();
        gatewayProperties.setRoutes(this.containsInvalidRoutes());
        gatewayProperties.setFailOnRouteDefinitionError(false);
        PropertiesRouteDefinitionLocator routeDefinitionLocator = new PropertiesRouteDefinitionLocator(gatewayProperties);
        RouteDefinitionRouteLocator routeDefinitionRouteLocator = new RouteDefinitionRouteLocator((RouteDefinitionLocator)new CompositeRouteDefinitionLocator(Flux.just((Object)routeDefinitionLocator)), predicates, gatewayFilterFactories, gatewayProperties, new ConfigurationService(null, () -> null, () -> null));
        StepVerifier.create((Publisher)routeDefinitionRouteLocator.getRoutes()).assertNext(route -> {
            List filters = route.getFilters();
            Assertions.assertThat((List)filters).hasSize(3);
            Assertions.assertThat((String)this.getFilterClassName((GatewayFilter)filters.get(0))).contains(new CharSequence[]{"RemoveResponseHeader"});
            Assertions.assertThat((String)this.getFilterClassName((GatewayFilter)filters.get(1))).contains(new CharSequence[]{"AddResponseHeader"});
            Assertions.assertThat((String)this.getFilterClassName((GatewayFilter)filters.get(2))).contains(new CharSequence[]{"RouteDefinitionRouteLocatorTests$TestOrderedGateway"});
        }).expectComplete().verify();
    }

    @Test
    public void contextLoadsAndApplyRouteIdToRetryFilter() {
        List<RoutePredicateFactory> predicates = Arrays.asList(new HostRoutePredicateFactory());
        List<GatewayFilterFactory> gatewayFilterFactories = Arrays.asList(new RetryGatewayFilterFactory(), new AddResponseHeaderGatewayFilterFactory());
        GatewayProperties gatewayProperties = new GatewayProperties();
        gatewayProperties.setDefaultFilters(Arrays.asList(new FilterDefinition("Retry")));
        gatewayProperties.setRoutes(Arrays.asList(new RouteDefinition(){
            {
                this.setId("foo");
                this.setUri(URI.create("https://foo.example.com"));
                this.setPredicates(Arrays.asList(new PredicateDefinition("Host=*.example.com")));
                this.setFilters(Arrays.asList(new FilterDefinition("AddResponseHeader=X-Response-Foo, Bar")));
            }
        }));
        PropertiesRouteDefinitionLocator routeDefinitionLocator = new PropertiesRouteDefinitionLocator(gatewayProperties);
        RouteDefinitionRouteLocator routeDefinitionRouteLocator = new RouteDefinitionRouteLocator((RouteDefinitionLocator)new CompositeRouteDefinitionLocator(Flux.just((Object)routeDefinitionLocator)), predicates, gatewayFilterFactories, gatewayProperties, new ConfigurationService(null, () -> null, () -> null));
        StepVerifier.create((Publisher)routeDefinitionRouteLocator.getRoutes()).assertNext(route -> {
            List filters = route.getFilters();
            Assertions.assertThat((List)filters).hasSize(2);
            Assertions.assertThat((String)((GatewayFilter)filters.get(0)).toString()).contains(new CharSequence[]{"routeId = 'foo'"});
            Assertions.assertThat((String)this.getFilterClassName((GatewayFilter)filters.get(0))).contains(new CharSequence[]{"Retry"});
            Assertions.assertThat((String)this.getFilterClassName((GatewayFilter)filters.get(1))).contains(new CharSequence[]{"AddResponseHeader"});
        }).expectComplete().verify();
    }

    private List<RouteDefinition> containsInvalidRoutes() {
        RouteDefinition foo = new RouteDefinition();
        foo.setId("foo");
        foo.setUri(URI.create("https://foo.example.com"));
        foo.setPredicates(Arrays.asList(new PredicateDefinition("Host=*.example.com")));
        foo.setFilters(Arrays.asList(new FilterDefinition("RemoveResponseHeader=Server"), new FilterDefinition("TestOrdered="), new FilterDefinition("AddResponseHeader=X-Response-Foo, Bar")));
        RouteDefinition bad = new RouteDefinition();
        bad.setId("exceptionRaised");
        bad.setUri(URI.create("https://foo.example.com"));
        bad.setPredicates(Arrays.asList(new PredicateDefinition("Host=*.example.com")));
        bad.setFilters(Arrays.asList(new FilterDefinition("Generate exception")));
        return Arrays.asList(foo, bad);
    }

    private String getFilterClassName(GatewayFilter target) {
        if (target instanceof OrderedGatewayFilter) {
            return this.getFilterClassName(((OrderedGatewayFilter)target).getDelegate());
        }
        String simpleName = target.getClass().getSimpleName();
        if (ObjectUtils.isEmpty((Object)simpleName)) {
            simpleName = target.toString();
        }
        return simpleName;
    }

    static class TestOrderedGatewayFilterFactory
    extends AbstractGatewayFilterFactory {
        TestOrderedGatewayFilterFactory() {
        }

        public GatewayFilter apply(Object config) {
            return new OrderedGatewayFilter((exchange, chain) -> chain.filter(exchange), 9999);
        }
    }
}

