/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.AdaptCachedBodyGlobalFilter;
import org.springframework.cloud.gateway.filter.ForwardPathFilter;
import org.springframework.cloud.gateway.filter.WebsocketRoutingFilter;
import org.springframework.cloud.gateway.filter.factory.AddRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.DedupeResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.FallbackHeadersGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.MapRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.handler.predicate.AfterRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.CloudFoundryRouteServiceRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.ReadBodyRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.RemoteAddrRoutePredicateFactory;
import org.springframework.cloud.gateway.support.NameUtils;

class NameUtilsTests {
    NameUtilsTests() {
    }

    @Test
    void shouldNormalizePredicatesNames() {
        List<Class> predicates = Arrays.asList(AfterRoutePredicateFactory.class, CloudFoundryRouteServiceRoutePredicateFactory.class, ReadBodyRoutePredicateFactory.class, RemoteAddrRoutePredicateFactory.class);
        List resultNames = predicates.stream().map(NameUtils::normalizeRoutePredicateName).collect(Collectors.toList());
        List<String> expectedNames = Arrays.asList("After", "CloudFoundryRouteService", "ReadBody", "RemoteAddr");
        Assertions.assertThat(resultNames).isEqualTo(expectedNames);
    }

    @Test
    void shouldNormalizePredicatesNamesAsProperties() {
        List<Class> predicates = Arrays.asList(AfterRoutePredicateFactory.class, CloudFoundryRouteServiceRoutePredicateFactory.class, ReadBodyRoutePredicateFactory.class, RemoteAddrRoutePredicateFactory.class);
        List resultNames = predicates.stream().map(NameUtils::normalizeRoutePredicateNameAsProperty).collect(Collectors.toList());
        List<String> expectedNames = Arrays.asList("after", "cloud-foundry-route-service", "read-body", "remote-addr");
        Assertions.assertThat(resultNames).isEqualTo(expectedNames);
    }

    @Test
    void shouldNormalizeFiltersNames() {
        List<Class> predicates = Arrays.asList(AddRequestHeaderGatewayFilterFactory.class, DedupeResponseHeaderGatewayFilterFactory.class, FallbackHeadersGatewayFilterFactory.class, MapRequestHeaderGatewayFilterFactory.class);
        List resultNames = predicates.stream().map(NameUtils::normalizeFilterFactoryName).collect(Collectors.toList());
        List<String> expectedNames = Arrays.asList("AddRequestHeader", "DedupeResponseHeader", "FallbackHeaders", "MapRequestHeader");
        Assertions.assertThat(resultNames).isEqualTo(expectedNames);
    }

    @Test
    void shouldNormalizeFiltersNamesAsProperties() {
        List<Class> predicates = Arrays.asList(AddRequestHeaderGatewayFilterFactory.class, DedupeResponseHeaderGatewayFilterFactory.class, FallbackHeadersGatewayFilterFactory.class, MapRequestHeaderGatewayFilterFactory.class);
        List resultNames = predicates.stream().map(NameUtils::normalizeFilterFactoryNameAsProperty).collect(Collectors.toList());
        List<String> expectedNames = Arrays.asList("add-request-header", "dedupe-response-header", "fallback-headers", "map-request-header");
        Assertions.assertThat(resultNames).isEqualTo(expectedNames);
    }

    @Test
    void shouldNormalizeGlobalFiltersNames() {
        List<Class> predicates = Arrays.asList(ForwardPathFilter.class, AdaptCachedBodyGlobalFilter.class, WebsocketRoutingFilter.class);
        List resultNames = predicates.stream().map(NameUtils::normalizeGlobalFilterName).collect(Collectors.toList());
        List<String> expectedNames = Arrays.asList("ForwardPath", "AdaptCachedBody", "WebsocketRouting");
        Assertions.assertThat(resultNames).isEqualTo(expectedNames);
    }

    @Test
    void shouldNormalizeGlobalFiltersNamesAsProperties() {
        List<Class> predicates = Arrays.asList(ForwardPathFilter.class, AdaptCachedBodyGlobalFilter.class, WebsocketRoutingFilter.class);
        List resultNames = predicates.stream().map(NameUtils::normalizeGlobalFilterNameAsProperty).collect(Collectors.toList());
        List<String> expectedNames = Arrays.asList("forward-path", "adapt-cached-body", "websocket-routing");
        Assertions.assertThat(resultNames).isEqualTo(expectedNames);
    }
}

