/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;

public class ServerWebExchangeUtilsTests {
    @Test
    public void expandWorks() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "bar");
        vars.put("baz", "bam");
        MockServerWebExchange exchange = this.mockExchange(vars);
        String expanded = ServerWebExchangeUtils.expand((ServerWebExchange)exchange, (String)"my-{foo}-{baz}");
        Assertions.assertThat((String)expanded).isEqualTo("my-bar-bam");
        expanded = ServerWebExchangeUtils.expand((ServerWebExchange)exchange, (String)"my-noop");
        Assertions.assertThat((String)expanded).isEqualTo("my-noop");
    }

    @Test
    public void missingVarThrowsException() {
        MockServerWebExchange exchange = this.mockExchange(Collections.emptyMap());
        Assert.assertThrows(IllegalArgumentException.class, () -> ServerWebExchangeUtils.expand((ServerWebExchange)exchange, (String)"my-{foo}-{baz}"));
    }

    @Test
    public void defaultDataBufferHandling() {
        MockServerWebExchange exchange = this.mockExchange(Collections.emptyMap());
        exchange.getAttributes().put("cachedRequestBody", "foo");
        ServerWebExchangeUtils.cacheRequestBodyAndRequest((ServerWebExchange)exchange, serverHttpRequest -> ServerRequest.create((ServerWebExchange)exchange.mutate().request(serverHttpRequest).build(), (List)HandlerStrategies.withDefaults().messageReaders()).bodyToMono(DefaultDataBuffer.class)).block();
    }

    private MockServerWebExchange mockExchange(Map<String, String> vars) {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"/get", (Object[])new Object[0]).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        ServerWebExchangeUtils.putUriTemplateVariables((ServerWebExchange)exchange, vars);
        return exchange;
    }
}

