/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test.ssl;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.netty.http.client.HttpClient;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
@ActiveProfiles(value={"single-cert-ssl"})
public class SingleCertSSLTests
extends BaseWebClientTests {
    @Override
    @BeforeEach
    public void setup() throws Exception {
        try {
            SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            HttpClient httpClient = HttpClient.create().secure(ssl -> ssl.sslContext(sslContext));
            this.setup((ClientHttpConnector)new ReactorClientHttpConnector(httpClient), "https://localhost:" + this.port);
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testSslTrust() {
        this.testClient.get().uri("/ssltrust", new Object[0]).exchange().expectStatus().is2xxSuccessful();
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    @RestController
    public static class TestConfig {
        @RequestMapping(value={"/httpbin/ssltrust"})
        public ResponseEntity<Void> nocontenttype() {
            return ResponseEntity.status((int)204).build();
        }
    }
}

