/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test.support;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.springframework.cloud.gateway.test.support.AbstractHttpServer;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;

public class ReactorHttpServer
extends AbstractHttpServer {
    private ReactorHttpHandlerAdapter reactorHandler;
    private HttpServer reactorServer;
    private AtomicReference<DisposableServer> serverRef = new AtomicReference();

    @Override
    protected void initServer() {
        this.reactorHandler = this.createHttpHandlerAdapter();
        this.reactorServer = HttpServer.create().host(this.getHost()).port(this.getPort());
    }

    private ReactorHttpHandlerAdapter createHttpHandlerAdapter() {
        return new ReactorHttpHandlerAdapter(this.resolveHttpHandler());
    }

    @Override
    protected void startInternal() {
        DisposableServer server = (DisposableServer)this.reactorServer.handle((BiFunction)this.reactorHandler).bind().block();
        this.setPort(server.port());
        this.serverRef.set(server);
    }

    @Override
    protected void stopInternal() {
        this.serverRef.get().dispose();
    }

    @Override
    protected void resetInternal() {
        this.reactorServer = null;
        this.reactorHandler = null;
        this.serverRef.set(null);
    }
}

