/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.micrometer.core.instrument.Tags;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayMetricsFilter;
import org.springframework.cloud.gateway.route.RouteDefinitionMetrics;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayTagsProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.server.ServerWebExchange;

@RunWith(value=Enclosed.class)
public class GatewayMetricsAutoConfigurationTests {

    @SpringBootConfiguration
    @EnableAutoConfiguration
    protected static class CustomTagsProviderConfig {
        protected CustomTagsProviderConfig() {
        }

        @Bean
        public GatewayTagsProvider emptyTagsProvider() {
            return new EmptyTagsProvider();
        }

        protected static class EmptyTagsProvider
        implements GatewayTagsProvider {
            protected EmptyTagsProvider() {
            }

            public Tags apply(ServerWebExchange exchange) {
                return Tags.empty();
            }
        }
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    protected static class Config {
        protected Config() {
        }
    }

    @RunWith(value=SpringRunner.class)
    @SpringBootTest(classes={CustomTagsProviderConfig.class}, properties={"spring.cloud.gateway.metrics.prefix=myprefix."})
    public static class AddCustomTagsProvider {
        @Autowired(required=false)
        private GatewayMetricsFilter filter;
        @Autowired(required=false)
        private RouteDefinitionMetrics routeDefinitionMetrics;
        @Autowired(required=false)
        private List<GatewayTagsProvider> tagsProviders;

        @Test
        public void gatewayMetricsBeansExists() {
            Assertions.assertThat((Object)this.filter).isNotNull();
            Assertions.assertThat((String)this.filter.getMetricsPrefix()).isEqualTo("myprefix");
            Assertions.assertThat(this.tagsProviders).extracting("class").contains(new Object[]{CustomTagsProviderConfig.EmptyTagsProvider.class});
        }

        @Test
        public void routeDefinitionMetricsBeanExists() {
            Assertions.assertThat((Object)this.routeDefinitionMetrics).isNotNull();
            Assertions.assertThat((String)this.routeDefinitionMetrics.getMetricsPrefix()).isEqualTo("myprefix");
        }
    }

    @RunWith(value=SpringRunner.class)
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.metrics.enabled=false"})
    public static class DisabledByProperty {
        @Autowired(required=false)
        private GatewayMetricsFilter filter;
        @Autowired(required=false)
        private RouteDefinitionMetrics routeDefinitionMetrics;

        @Test
        public void gatewayMetricsBeanMissing() {
            Assertions.assertThat((Object)this.filter).isNull();
        }

        @Test
        public void routeDefinitionMetricsBeanMissing() {
            Assertions.assertThat((Object)this.routeDefinitionMetrics).isNull();
        }
    }

    @RunWith(value=SpringRunner.class)
    @SpringBootTest(classes={Config.class})
    public static class EnabledByDefault {
        @Autowired(required=false)
        private GatewayMetricsFilter filter;
        @Autowired(required=false)
        private RouteDefinitionMetrics routeDefinitionMetrics;
        @Autowired(required=false)
        private List<GatewayTagsProvider> tagsProviders;

        @Test
        public void gatewayMetricsBeansExists() {
            Assertions.assertThat((Object)this.filter).isNotNull();
            Assertions.assertThat((String)this.filter.getMetricsPrefix()).isEqualTo("spring.cloud.gateway");
            Assertions.assertThat(this.tagsProviders).isNotEmpty();
        }

        @Test
        public void routeDefinitionMetricsBeanExists() {
            Assertions.assertThat((Object)this.routeDefinitionMetrics).isNotNull();
            Assertions.assertThat((String)this.routeDefinitionMetrics.getMetricsPrefix()).isEqualTo("spring.cloud.gateway");
        }
    }
}

