/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.ratelimit.RedisRateLimiter;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=Enclosed.class)
public class GatewayRedisAutoConfigurationTests {

    @RunWith(value=SpringRunner.class)
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.redis.enabled=false"})
    public static class DisabledByProperty {
        @Autowired(required=false)
        private RedisScript redisRequestRateLimiterScript;
        @Autowired(required=false)
        private RedisRateLimiter redisRateLimiter;

        @Test
        public void shouldDisableRedisBeans() {
            Assertions.assertThat((Object)this.redisRequestRateLimiterScript).isNull();
            Assertions.assertThat((Object)this.redisRateLimiter).isNull();
        }
    }

    @RunWith(value=SpringRunner.class)
    @SpringBootTest(classes={Config.class})
    public static class EnabledByDefault {
        @Autowired(required=false)
        private RedisScript redisRequestRateLimiterScript;
        @Autowired(required=false)
        private RedisRateLimiter redisRateLimiter;

        @Test
        public void shouldInjectRedisBeans() {
            Assertions.assertThat((Object)this.redisRequestRateLimiterScript).isNotNull();
            Assertions.assertThat((Object)this.redisRateLimiter).isNotNull();
        }
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    protected static class Config {
        protected Config() {
        }
    }
}

