/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.discovery;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.gateway.discovery.DiscoveryClientRouteDefinitionLocator;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.test.context.junit4.SpringRunner;
import reactor.core.publisher.Flux;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.discovery.locator.enabled=true", "spring.cloud.gateway.discovery.locator.route-id-prefix=testedge_", "spring.cloud.gateway.discovery.locator.include-expression=metadata['edge'] == 'true'", "spring.cloud.gateway.discovery.locator.lower-case-service-id=true"})
public class DiscoveryClientRouteDefinitionLocatorTests {
    @Autowired(required=false)
    private DiscoveryClientRouteDefinitionLocator locator;

    @Test
    public void includeExpressionWorks() {
        ((ObjectAssert)Assertions.assertThat((Object)this.locator).as("DiscoveryClientRouteDefinitionLocator was null", new Object[0])).isNotNull();
        List definitions = (List)this.locator.getRouteDefinitions().collectList().block();
        Assertions.assertThat((List)definitions).hasSize(1);
        RouteDefinition definition = (RouteDefinition)definitions.get(0);
        Assertions.assertThat((String)definition.getId()).isEqualTo("testedge_SERVICE1");
        Assertions.assertThat((URI)definition.getUri()).hasScheme("lb").hasHost("SERVICE1");
        Assertions.assertThat((Map)definition.getMetadata()).containsEntry((Object)"edge", (Object)"true");
        Assertions.assertThat((List)definition.getPredicates()).hasSize(1);
        PredicateDefinition predicate = (PredicateDefinition)definition.getPredicates().get(0);
        Assertions.assertThat((String)predicate.getName()).isEqualTo("Path");
        ((MapAssert)Assertions.assertThat((Map)predicate.getArgs()).hasSize(1)).containsEntry((Object)"pattern", (Object)"/service1/**");
        Assertions.assertThat((List)definition.getFilters()).hasSize(1);
        FilterDefinition filter = (FilterDefinition)definition.getFilters().get(0);
        Assertions.assertThat((String)filter.getName()).isEqualTo("RewritePath");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)filter.getArgs()).hasSize(2)).containsEntry((Object)"regexp", (Object)"/service1/?(?<remaining>.*)")).containsEntry((Object)"replacement", (Object)"/${remaining}");
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    protected static class Config {
        protected Config() {
        }

        @Bean
        ReactiveDiscoveryClient discoveryClient() {
            ReactiveDiscoveryClient discoveryClient = (ReactiveDiscoveryClient)Mockito.mock(ReactiveDiscoveryClient.class);
            Mockito.when((Object)discoveryClient.getServices()).thenReturn((Object)Flux.just((Object[])new String[]{"SERVICE1", "Service2"}));
            this.whenInstance(discoveryClient, "SERVICE1", Collections.singletonMap("edge", "true"));
            this.whenInstance(discoveryClient, "Service2", Collections.emptyMap());
            return discoveryClient;
        }

        private void whenInstance(ReactiveDiscoveryClient discoveryClient, String serviceId, Map<String, String> metadata) {
            DefaultServiceInstance instance1 = new DefaultServiceInstance(serviceId + "8001", serviceId, "localhost", 8001, false, metadata);
            Mockito.when((Object)discoveryClient.getInstances(serviceId)).thenReturn((Object)Flux.just((Object)instance1));
        }
    }
}

