/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.NettyRoutingFilter;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(properties={"spring.cloud.gateway.routes[0].id=route_connect_timeout", "spring.cloud.gateway.routes[0].uri=http://localhost:32167", "spring.cloud.gateway.routes[0].predicates[0].name=Path", "spring.cloud.gateway.routes[0].predicates[0].args[pattern]=/connect/delay/{timeout}", "spring.cloud.gateway.routes[0].metadata[connect-timeout]=5", "spring.cloud.gateway.routes[1].id=route_response_timeout", "spring.cloud.gateway.routes[1].uri=lb://testservice", "spring.cloud.gateway.routes[1].predicates[0].name=Path", "spring.cloud.gateway.routes[1].predicates[0].args[pattern]=/route/delay/{timeout}", "spring.cloud.gateway.routes[1].filters[0]=StripPrefix=1", "spring.cloud.gateway.routes[1].metadata.response-timeout=1000"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
class NettyRoutingFilterCompatibleTests
extends BaseWebClientTests {
    NettyRoutingFilterCompatibleTests() {
    }

    @Test
    void shouldApplyConnectTimeoutPerRoute() {
        Assertions.assertThat((Integer)NettyRoutingFilter.getInteger((Object)"5")).isEqualTo(5);
        Assertions.assertThat((Integer)NettyRoutingFilter.getInteger((Object)5)).isEqualTo(5);
    }

    @Test
    void shouldApplyResponseTimeoutPerRoute() {
        this.testClient.get().uri("/route/delay/2", new Object[0]).exchange().expectStatus().isEqualTo(HttpStatus.GATEWAY_TIMEOUT).expectBody().jsonPath("$.status", new Object[0]).isEqualTo((Object)String.valueOf(HttpStatus.GATEWAY_TIMEOUT.value())).jsonPath("$.message", new Object[0]).isEqualTo((Object)"Response took longer than timeout: PT1S");
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    static class TestConfig {
        TestConfig() {
        }
    }
}

