/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.cloud.gateway.filter.NettyWriteResponseFilter;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.mock.http.server.reactive.MockServerHttpResponse;

public class NettyWriteResponseFilterTests {
    @Test
    public void testWrap_NettyDataBufferFactory() {
        this.doTestWrap(new MockServerHttpResponse((DataBufferFactory)new NettyDataBufferFactory((ByteBufAllocator)PooledByteBufAllocator.DEFAULT)));
    }

    @Test
    public void testWrap_DefaultDataBufferFactory() {
        this.doTestWrap(new MockServerHttpResponse());
    }

    private void doTestWrap(MockServerHttpResponse response) {
        NettyWriteResponseFilter filter = new NettyWriteResponseFilter(new ArrayList());
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        buffer.writeCharSequence((CharSequence)"test", Charset.defaultCharset());
        DataBuffer result = filter.wrap(buffer, (ServerHttpResponse)response);
        Assertions.assertThat((String)result.toString(Charset.defaultCharset())).isEqualTo("test");
        if (result instanceof PooledDataBuffer) {
            ((PooledDataBuffer)result).release();
        }
        Assertions.assertThat((int)buffer.refCnt()).isEqualTo(0);
    }
}

