/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.WebsocketRoutingFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.server.ServerWebExchange;

public class WebsocketRoutingFilterTests {
    @Test
    public void testProtocolParsing() {
        ObjectProvider headersFilters = (ObjectProvider)Mockito.mock(ObjectProvider.class);
        WebsocketRoutingFilter filter = new WebsocketRoutingFilter((WebSocketClient)Mockito.mock(WebSocketClient.class), (WebSocketService)Mockito.mock(WebSocketService.class), headersFilters);
        HttpHeaders headers = new HttpHeaders();
        headers.put("Sec-WebSocket-Protocol", Arrays.asList(" p1,p2", "p3 , p4 "));
        List protocols = filter.getProtocols(headers);
        Assertions.assertThat((List)protocols).containsExactly((Object[])new String[]{"p1", "p2", "p3", "p4"});
    }

    @Test
    public void testConvertHttpToWs() {
        Assertions.assertThat((String)WebsocketRoutingFilter.convertHttpToWs((String)"http")).isEqualTo("ws");
        Assertions.assertThat((String)WebsocketRoutingFilter.convertHttpToWs((String)"HTTP")).isEqualTo("ws");
        Assertions.assertThat((String)WebsocketRoutingFilter.convertHttpToWs((String)"https")).isEqualTo("wss");
        Assertions.assertThat((String)WebsocketRoutingFilter.convertHttpToWs((String)"HTTPS")).isEqualTo("wss");
        Assertions.assertThat((String)WebsocketRoutingFilter.convertHttpToWs((String)"tcp")).isEqualTo("tcp");
    }

    @Test
    public void testEncodedUrl() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://not-matters-that", (Object[])new Object[0]).header("Upgrade", new String[]{"WebSocket"}).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, URI.create("http://microservice/my-service/websocket%20upgrade"));
        WebsocketRoutingFilter.changeSchemeIfIsWebSocketUpgrade((ServerWebExchange)exchange);
        URI wsRequestUrl = (URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)wsRequestUrl).isEqualTo((Object)URI.create("ws://microservice/my-service/websocket%20upgrade"));
    }

    @Test
    public void testHeadersFilter() {
        this.assertDefaultHeadersFilters(false);
    }

    @Test
    public void testHeadersFilterPreserveHost() {
        this.assertDefaultHeadersFilters(true);
    }

    private void assertDefaultHeadersFilters(boolean preserveHostHeader) {
        ObjectProvider headersFilters = (ObjectProvider)Mockito.mock(ObjectProvider.class);
        Mockito.when((Object)headersFilters.getIfAvailable((Supplier)ArgumentMatchers.any())).thenReturn(new ArrayList());
        WebsocketRoutingFilter filter = new WebsocketRoutingFilter((WebSocketClient)Mockito.mock(WebSocketClient.class), (WebSocketService)Mockito.mock(WebSocketService.class), headersFilters);
        List filters = filter.getHeadersFilters();
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"ws://not-matters-that", (Object[])new Object[0]).header("Host", new String[]{"MyHost"}).header("Sec-Websocket-Something", new String[]{"someval"}).header("x-foo", new String[]{"bar"}).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        exchange.getAttributes().put(ServerWebExchangeUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, preserveHostHeader);
        HttpHeaders httpHeaders = HttpHeadersFilter.filterRequest((List)filters, (ServerWebExchange)exchange);
        Assertions.assertThat((Map)httpHeaders).doesNotContainKeys((Object[])new String[]{"Sec-Websocket-Something"}).containsKey((Object)"x-foo");
        if (preserveHostHeader) {
            Assertions.assertThat((Map)httpHeaders).containsKey((Object)"Host");
        } else {
            Assertions.assertThat((Map)httpHeaders).doesNotContainKeys((Object[])new String[]{"Host"});
        }
    }
}

