/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.RewriteResponseHeaderGatewayFilterFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;

public class RewriteResponseHeaderGatewayFilterFactoryUnitTests {
    private RewriteResponseHeaderGatewayFilterFactory filterFactory;

    @Before
    public void setUp() {
        this.filterFactory = new RewriteResponseHeaderGatewayFilterFactory();
    }

    @Test
    public void testRewriteDollarSlash() {
        Assertions.assertThat((String)this.filterFactory.rewrite("/foo/bar", "/foo/(?<segment>.*)", "/$\\{segment}/$\\{segment}/42")).isEqualTo("/bar/bar/42");
    }

    @Test
    public void testRewriteMultiple() {
        Assertions.assertThat((String)this.filterFactory.rewrite("/foo/bar/wat/bar", "bar", "cafe")).isEqualTo("/foo/cafe/wat/cafe");
    }

    @Test
    public void testRewriteMultipleHeaders() {
        RewriteResponseHeaderGatewayFilterFactory.Config config = new RewriteResponseHeaderGatewayFilterFactory.Config();
        config.setName("Set-Cookie");
        config.setRegexp("SameSite[^;]+");
        config.setReplacement("SameSite=Strict");
        ServerWebExchange exchange = (ServerWebExchange)Mockito.mock(ServerWebExchange.class);
        ServerHttpResponse response = (ServerHttpResponse)Mockito.mock(ServerHttpResponse.class);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Set-Cookie", "TestCookie=Value;SameSite=Lax");
        headers.add("Set-Cookie", "OtherCookie=Value;SameSite=Lax");
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
        Mockito.when((Object)exchange.getResponse()).thenReturn((Object)response);
        this.filterFactory.rewriteHeaders(exchange, config);
        List actualHeaders = headers.get((Object)"Set-Cookie");
        Assertions.assertThat((List)actualHeaders).isNotNull();
        Assertions.assertThat((List)actualHeaders).containsExactly((Object[])new String[]{"TestCookie=Value;SameSite=Strict", "OtherCookie=Value;SameSite=Strict"});
    }

    @Test
    public void toStringFormat() {
        RewriteResponseHeaderGatewayFilterFactory.Config config = new RewriteResponseHeaderGatewayFilterFactory.Config();
        config.setName("myname");
        config.setRegexp("myregexp");
        config.setReplacement("myreplacement");
        GatewayFilter filter = new RewriteResponseHeaderGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myname"})).contains(new CharSequence[]{"myregexp"})).contains(new CharSequence[]{"myreplacement"});
    }
}

