/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.cloud.gateway.filter.headers.RemoveHopByHopHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class RemoveHopByHopHeadersFilterTests {
    @Test
    public void happyPath() {
        MockServerHttpRequest.BaseBuilder builder = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]);
        RemoveHopByHopHeadersFilter.HEADERS_REMOVED_ON_REQUEST.forEach(header -> builder.header(header, new String[]{header + "1"}));
        this.testFilter(MockServerWebExchange.from((MockServerHttpRequest.BaseBuilder)builder), new String[0]);
    }

    @Test
    public void caseInsensitive() {
        MockServerHttpRequest.BaseBuilder builder = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]);
        RemoveHopByHopHeadersFilter.HEADERS_REMOVED_ON_REQUEST.forEach(header -> builder.header(header.toLowerCase(), new String[]{header + "1"}));
        this.testFilter(MockServerWebExchange.from((MockServerHttpRequest.BaseBuilder)builder), new String[0]);
    }

    @Test
    public void removesHeadersListedInConnectionHeader() {
        MockServerHttpRequest.BaseBuilder builder = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]);
        builder.header("Connection", new String[]{"upgrade", "keep-alive"});
        builder.header("Upgrade", new String[]{"WebSocket"});
        builder.header("Keep-Alive", new String[]{"timeout:5"});
        this.testFilter(MockServerWebExchange.from((MockServerHttpRequest.BaseBuilder)builder), "upgrade", "keep-alive");
    }

    private void testFilter(MockServerWebExchange exchange, String ... additionalHeaders) {
        RemoveHopByHopHeadersFilter filter = new RemoveHopByHopHeadersFilter();
        HttpHeaders headers = filter.filter(exchange.getRequest().getHeaders(), (ServerWebExchange)exchange);
        HashSet<String> toRemove = new HashSet<String>(RemoveHopByHopHeadersFilter.HEADERS_REMOVED_ON_REQUEST);
        toRemove.addAll(Arrays.asList(additionalHeaders));
        Assertions.assertThat((Map)headers).doesNotContainKeys((Object[])toRemove.toArray(new String[0]));
    }
}

