/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.cloud.gateway.handler.predicate.AfterRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.BetweenRoutePredicateFactoryTests;

public class AfterRoutePredicateFactoryTests {
    @Test
    public void beforeStringWorks() {
        String dateString = BetweenRoutePredicateFactoryTests.minusHours(1);
        boolean result = this.runPredicate(dateString);
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    public void afterStringWorks() {
        String dateString = BetweenRoutePredicateFactoryTests.plusHours(1);
        boolean result = this.runPredicate(dateString);
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void beforeEpochWorks() {
        String dateString = BetweenRoutePredicateFactoryTests.minusHoursMillis(1);
        boolean result = this.runPredicate(dateString);
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    public void afterEpochWorks() {
        String dateString = BetweenRoutePredicateFactoryTests.plusHoursMillis(1);
        boolean result = this.runPredicate(dateString);
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void testPredicates() {
        boolean result = new AfterRoutePredicateFactory().apply(c -> c.setDatetime(ZonedDateTime.now().minusHours(2L))).test(BetweenRoutePredicateFactoryTests.getExchange());
        Assertions.assertThat((boolean)result).isTrue();
    }

    private boolean runPredicate(String dateString) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datetime", dateString);
        AfterRoutePredicateFactory factory = new AfterRoutePredicateFactory();
        AfterRoutePredicateFactory.Config config = (AfterRoutePredicateFactory.Config)BetweenRoutePredicateFactoryTests.bindConfig(map, factory);
        return factory.apply(config).test(BetweenRoutePredicateFactoryTests.getExchange());
    }

    @Test
    public void toStringFormat() {
        AfterRoutePredicateFactory.Config config = new AfterRoutePredicateFactory.Config();
        config.setDatetime(ZonedDateTime.now());
        Predicate predicate = new AfterRoutePredicateFactory().apply(config);
        Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"After: " + config.getDatetime()});
    }
}

