/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.BetweenRoutePredicateFactory;
import org.springframework.cloud.gateway.support.ConfigurationService;
import org.springframework.cloud.gateway.support.StringToZonedDateTimeConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class BetweenRoutePredicateFactoryTests {
    static <T> T bindConfig(HashMap<String, Object> properties, AbstractRoutePredicateFactory<T> factory) {
        ApplicationConversionService conversionService = new ApplicationConversionService();
        conversionService.addConverter((Converter)new StringToZonedDateTimeConverter());
        Object config = ((ConfigurationService.ConfigurableBuilder)((ConfigurationService.ConfigurableBuilder)new ConfigurationService(null, () -> conversionService, () -> null).with(factory).name("myname")).normalizedProperties(properties)).bind();
        return (T)config;
    }

    static String minusHoursMillis(int hours) {
        int millis = hours * 1000 * 60 * 60;
        return String.valueOf(System.currentTimeMillis() - (long)millis);
    }

    static String plusHoursMillis(int hours) {
        int millis = hours * 1000 * 60 * 60;
        return String.valueOf(System.currentTimeMillis() + (long)millis);
    }

    static String minusHours(int hours) {
        return ZonedDateTime.now().minusHours(hours).format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    static String plusHours(int hours) {
        return ZonedDateTime.now().plusHours(hours).format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    static ServerWebExchange getExchange() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"https://example.com", (Object[])new Object[0]).build();
        return MockServerWebExchange.from((MockServerHttpRequest)request);
    }

    @Test
    public void beforeStringWorks() {
        String dateString1 = BetweenRoutePredicateFactoryTests.plusHours(1);
        String dateString2 = BetweenRoutePredicateFactoryTests.plusHours(2);
        boolean result = this.runPredicate(dateString1, dateString2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("Now is not before %s", new Object[]{dateString1})).isFalse();
    }

    @Test
    public void betweenStringWorks() {
        String dateString1 = BetweenRoutePredicateFactoryTests.minusHours(1);
        String dateString2 = BetweenRoutePredicateFactoryTests.plusHours(1);
        ZonedDateTime parse = ZonedDateTime.parse(dateString1);
        boolean result = this.runPredicate(dateString1, dateString2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("Now is not between %s and %s", new Object[]{dateString1, dateString2})).isTrue();
    }

    @Test
    public void afterStringWorks() {
        String dateString1 = BetweenRoutePredicateFactoryTests.minusHours(2);
        String dateString2 = BetweenRoutePredicateFactoryTests.minusHours(1);
        boolean result = this.runPredicate(dateString1, dateString2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("Now is not after %s", new Object[]{dateString2})).isFalse();
    }

    @Test
    public void beforeEpochWorks() {
        String dateString1 = BetweenRoutePredicateFactoryTests.plusHoursMillis(1);
        String dateString2 = BetweenRoutePredicateFactoryTests.plusHoursMillis(2);
        boolean result = this.runPredicate(dateString1, dateString2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("Now is not before %s", new Object[]{dateString1})).isFalse();
    }

    @Test
    public void betweenEpochWorks() {
        String dateString1 = BetweenRoutePredicateFactoryTests.minusHoursMillis(1);
        String dateString2 = BetweenRoutePredicateFactoryTests.plusHoursMillis(1);
        boolean result = this.runPredicate(dateString1, dateString2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("Now is not between %s and %s", new Object[]{dateString1, dateString2})).isTrue();
    }

    @Test
    public void afterEpochWorks() {
        String dateString1 = BetweenRoutePredicateFactoryTests.minusHoursMillis(2);
        String dateString2 = BetweenRoutePredicateFactoryTests.minusHoursMillis(1);
        boolean result = this.runPredicate(dateString1, dateString2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("Now is not after %s", new Object[]{dateString1})).isFalse();
    }

    @Test
    public void testPredicates() {
        boolean result = new BetweenRoutePredicateFactory().apply(c -> c.setDatetime1(ZonedDateTime.now().minusHours(2L)).setDatetime2(ZonedDateTime.now().plusHours(1L))).test(BetweenRoutePredicateFactoryTests.getExchange());
        Assertions.assertThat((boolean)result).isTrue();
    }

    boolean runPredicate(String dateString1, String dateString2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datetime1", dateString1);
        map.put("datetime2", dateString2);
        BetweenRoutePredicateFactory factory = new BetweenRoutePredicateFactory();
        BetweenRoutePredicateFactory.Config config = (BetweenRoutePredicateFactory.Config)BetweenRoutePredicateFactoryTests.bindConfig(map, factory);
        return factory.apply(config).test(BetweenRoutePredicateFactoryTests.getExchange());
    }

    @Test
    public void toStringFormat() {
        BetweenRoutePredicateFactory.Config config = new BetweenRoutePredicateFactory.Config();
        config.setDatetime1(ZonedDateTime.now());
        config.setDatetime2(ZonedDateTime.now().plusHours(1L));
        Predicate predicate = new BetweenRoutePredicateFactory().apply(config);
        Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"Between: " + config.getDatetime1() + " and " + config.getDatetime2()});
    }
}

