/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import com.fasterxml.jackson.databind.JsonNode;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class CloudFoundryRouteServiceRoutePredicateFactoryIntegrationTests
extends BaseWebClientTests {
    @LocalServerPort
    int port;

    @Test
    public void predicateWorkWithProperties() {
        this.testClient.get().uri("/", new Object[0]).header("Host", new String[]{"props.routeservice.example.com"}).header("X-CF-Forwarded-Url", new String[]{"http://localhost:" + this.port + "/actuator/health"}).header("X-CF-Proxy-Signature", new String[]{"foo"}).header("X-CF-Proxy-Metadata", new String[]{"bar"}).exchange().expectBody(JsonNode.class).consumeWith(r -> Assertions.assertThat((boolean)((JsonNode)r.getResponseBody()).has("status")).isTrue());
    }

    @Test
    public void predicateWillNotWorkUnlessHeadersAreEnough() {
        this.testClient.get().uri("/", new Object[0]).header("Host", new String[]{"props.routeservice.example.com"}).header("X-CF-Forwarded-Url", new String[]{"http://localhost:" + this.port + "/actuator/health"}).header("X-CF-Proxy-Metadata", new String[]{"bar"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"default_path_to_httpbin"});
    }

    @Test
    public void predicateWorkWithDsl() {
        this.testClient.get().uri("/", new Object[0]).header("Host", new String[]{"dsl.routeservice.example.com"}).header("X-CF-Forwarded-Url", new String[]{"http://localhost:" + this.port + "/actuator/health"}).header("X-CF-Proxy-Signature", new String[]{"foo"}).header("X-CF-Proxy-Metadata", new String[]{"bar"}).exchange().expectBody(JsonNode.class).consumeWith(r -> Assertions.assertThat((boolean)((JsonNode)r.getResponseBody()).has("status")).isTrue());
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Bean
        public RouteLocator routeLocator(RouteLocatorBuilder builder) {
            return builder.routes().route(r -> r.cloudFoundryRouteService().and().header("Host", "dsl.routeservice.example.com").filters(f -> f.requestHeaderToRequestUri("X-CF-Forwarded-Url")).uri("https://example.com")).build();
        }
    }
}

