/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.springframework.cloud.gateway.handler.predicate.CloudFoundryRouteServiceRoutePredicateFactory;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class CloudFoundryRouteServiceRoutePredicateFactoryTest {
    private Predicate<ServerWebExchange> predicate;

    @Before
    public void setUp() throws Exception {
        CloudFoundryRouteServiceRoutePredicateFactory factory = new CloudFoundryRouteServiceRoutePredicateFactory();
        this.predicate = factory.apply(factory.newConfig());
    }

    @Test
    public void itReturnsTrueWithAllHeadersPresent() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"someurl", (Object[])new Object[0]).header("X-CF-Forwarded-Url", new String[]{"url"}).header("X-CF-Proxy-Metadata", new String[]{"metadata"}).header("X-CF-Proxy-Signature", new String[]{"signature"}).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        Assertions.assertThat((boolean)this.predicate.test((ServerWebExchange)exchange)).isTrue();
    }

    @Test
    public void itReturnsFalseWithAHeadersMissing() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"someurl", (Object[])new Object[0]).header("X-CF-Forwarded-Url", new String[]{"url"}).header("X-CF-Proxy-Metadata", new String[]{"metadata"}).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        Assertions.assertThat((boolean)this.predicate.test((ServerWebExchange)exchange)).isFalse();
    }

    @Test
    public void itReturnsFalseWithNoHeaders() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"someurl", (Object[])new Object[0]).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        Assertions.assertThat((boolean)this.predicate.test((ServerWebExchange)exchange)).isFalse();
    }
}

