/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route.builder;

import java.net.URI;
import java.util.Map;
import org.assertj.core.util.Maps;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;
import reactor.test.StepVerifier;

@RunWith(value=SpringRunner.class)
@SpringBootTest
public class RouteBuilderTests {
    @Autowired
    private RouteLocatorBuilder routeLocatorBuilder;

    @Test
    public void testASetOfRoutes() {
        RouteLocator routeLocator2 = this.routeLocatorBuilder.routes().route("test1", r -> r.host(new String[]{"*.somehost.org"}).and().path(new String[]{"/somepath"}).filters(f -> f.addRequestHeader("header1", "header-value-1")).uri("http://someuri")).route("test2", r -> r.host(new String[]{"*.somehost2.org"}).filters(f -> f.addResponseHeader("header-response-1", "header-response-1")).uri("https://httpbin.org:9090")).build();
        StepVerifier.create((Publisher)routeLocator2.getRoutes()).expectNextMatches(r -> r.getId().equals("test1") && r.getFilters().size() == 1 && r.getUri().equals(URI.create("http://someuri:80"))).expectNextMatches(r -> r.getId().equals("test2") && r.getFilters().size() == 1 && r.getUri().equals(URI.create("https://httpbin.org:9090"))).expectComplete().verify();
    }

    @Test
    public void testRouteOptionsPropagatedToRoute() {
        Map routeMetadata = Maps.newHashMap((Object)"key", (Object)"value");
        RouteLocator routeLocator2 = this.routeLocatorBuilder.routes().route("test1", r -> r.host(new String[]{"*.somehost.org"}).and().path(new String[]{"/somepath"}).filters(f -> f.addRequestHeader("header1", "header-value-1")).metadata("key", (Object)"value").uri("http://someuri")).route("test2", r -> r.host(new String[]{"*.somehost2.org"}).filters(f -> f.addResponseHeader("header-response-1", "header-response-1")).uri("https://httpbin.org:9090")).build();
        StepVerifier.create((Publisher)routeLocator2.getRoutes()).expectNextMatches(r -> r.getId().equals("test1") && r.getFilters().size() == 1 && r.getUri().equals(URI.create("http://someuri:80")) && r.getMetadata().equals(routeMetadata)).expectNextMatches(r -> r.getId().equals("test2") && r.getFilters().size() == 1 && r.getUri().equals(URI.create("https://httpbin.org:9090")) && r.getMetadata().isEmpty()).expectComplete().verify();
    }

    @Test
    public void testRoutesWithTimeout() {
        RouteLocator routeLocator2 = this.routeLocatorBuilder.routes().route("test1", r -> r.host(new String[]{"*.somehost.org"}).and().path(new String[]{"/somepath"}).filters(f -> f.addRequestHeader("header1", "header-value-1")).metadata("response-timeout", (Object)1).metadata("connect-timeout", (Object)1).uri("http://someuri")).route("test2", r -> r.host(new String[]{"*.somehost2.org"}).filters(f -> f.addResponseHeader("header-response-1", "header-response-1")).uri("https://httpbin.org:9090")).build();
        StepVerifier.create((Publisher)routeLocator2.getRoutes()).expectNextMatches(r -> r.getId().equals("test1") && r.getFilters().size() == 1 && r.getUri().equals(URI.create("http://someuri:80")) && r.getMetadata().get("response-timeout").equals(1) && r.getMetadata().get("connect-timeout").equals(1)).expectNextMatches(r -> r.getId().equals("test2") && r.getFilters().size() == 1 && r.getUri().equals(URI.create("https://httpbin.org:9090"))).expectComplete().verify();
    }

    @EnableAutoConfiguration
    @Configuration(proxyBeanMethods=false)
    public static class SpringConfig {
    }
}

