/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support.tagsprovider;

import io.micrometer.core.instrument.Tags;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayHttpTagsProvider;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpResponse;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class GatewayHttpTagsProviderTests {
    private final GatewayHttpTagsProvider tagsProvider = new GatewayHttpTagsProvider();
    private static final String ROUTE_URI = "http://gatewaytagsprovider.org:80";
    private static final Tags DEFAULT_TAGS = Tags.of((String[])new String[]{"outcome", HttpStatus.OK.series().name(), "status", HttpStatus.OK.name(), "httpStatusCode", String.valueOf(HttpStatus.OK.value()), "httpMethod", "GET"});

    @Test
    public void httpTags() {
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)ROUTE_URI, (Object[])new Object[0]).build());
        exchange.getResponse().setStatusCode(HttpStatus.OK);
        Tags tags = this.tagsProvider.apply((ServerWebExchange)exchange);
        Assertions.assertThat((Iterable)tags).isEqualTo((Object)DEFAULT_TAGS);
    }

    @Test
    public void statusNotChanged() {
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)ROUTE_URI, (Object[])new Object[0]).build());
        Tags tags = this.tagsProvider.apply((ServerWebExchange)exchange);
        Assertions.assertThat((Iterable)tags).isEqualTo((Object)Tags.of((String[])new String[]{"outcome", "CUSTOM", "status", "CUSTOM", "httpStatusCode", "NA", "httpMethod", "GET"}));
    }

    @Test
    public void notAbstractServerHttpResponse() {
        ServerWebExchange mockExchange = (ServerWebExchange)Mockito.mock(ServerWebExchange.class);
        ServerHttpResponseDecorator responseDecorator = new ServerHttpResponseDecorator((ServerHttpResponse)new MockServerHttpResponse());
        responseDecorator.setStatusCode(HttpStatus.OK);
        Mockito.when((Object)mockExchange.getRequest()).thenReturn((Object)MockServerHttpRequest.get((String)ROUTE_URI, (Object[])new Object[0]).build());
        Mockito.when((Object)mockExchange.getResponse()).thenReturn((Object)responseDecorator);
        Tags tags = this.tagsProvider.apply(mockExchange);
        Assertions.assertThat((Iterable)tags).isEqualTo((Object)DEFAULT_TAGS);
    }
}

