/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test.support;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.test.support.HttpServer;
import org.springframework.http.server.reactive.ContextPathCompositeHandler;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;

public abstract class AbstractHttpServer
implements HttpServer {
    private final Object lifecycleMonitor = new Object();
    protected Log logger = LogFactory.getLog((String)this.getClass().getName());
    private String host = "0.0.0.0";
    private int port = 0;
    private HttpHandler httpHandler;
    private Map<String, HttpHandler> handlerMap;
    private volatile boolean running;

    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void setHandler(HttpHandler handler) {
        this.httpHandler = handler;
    }

    public HttpHandler getHttpHandler() {
        return this.httpHandler;
    }

    public void registerHttpHandler(String contextPath, HttpHandler handler) {
        if (this.handlerMap == null) {
            this.handlerMap = new LinkedHashMap<String, HttpHandler>();
        }
        this.handlerMap.put(contextPath, handler);
    }

    public Map<String, HttpHandler> getHttpHandlerMap() {
        return this.handlerMap;
    }

    protected HttpHandler resolveHttpHandler() {
        return this.getHttpHandlerMap() != null ? new ContextPathCompositeHandler(this.getHttpHandlerMap()) : this.getHttpHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.host, (String)"Host must not be null");
        Assert.isTrue((this.port >= 0 ? 1 : 0) != 0, (String)"Port must not be a negative number");
        Assert.isTrue((this.httpHandler != null || this.handlerMap != null ? 1 : 0) != 0, (String)"No HttpHandler configured");
        Assert.state((!this.running ? 1 : 0) != 0, (String)"Cannot reconfigure while running");
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.initServer();
        }
    }

    protected abstract void initServer() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                String serverName = this.getClass().getSimpleName();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Starting " + serverName + "..."));
                }
                this.running = true;
                try {
                    StopWatch stopWatch = new StopWatch();
                    stopWatch.start();
                    this.startInternal();
                    long millis = stopWatch.getTotalTimeMillis();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Server started on port " + this.getPort() + "(" + millis + " millis)."));
                    }
                }
                catch (Throwable ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
    }

    protected abstract void startInternal() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                String serverName = this.getClass().getSimpleName();
                this.logger.debug((Object)("Stopping " + serverName + "..."));
                this.running = false;
                try {
                    StopWatch stopWatch = new StopWatch();
                    stopWatch.start();
                    this.stopInternal();
                    this.logger.debug((Object)("Server stopped (" + stopWatch.getTotalTimeMillis() + " millis)."));
                }
                catch (Throwable ex) {
                    throw new IllegalStateException(ex);
                }
                finally {
                    this.reset();
                }
            }
        }
    }

    protected abstract void stopInternal() throws Exception;

    public boolean isRunning() {
        return this.running;
    }

    private void reset() {
        this.host = "0.0.0.0";
        this.port = 0;
        this.httpHandler = null;
        this.handlerMap = null;
        this.resetInternal();
    }

    protected abstract void resetInternal();
}

