/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.support.Configurable;
import org.springframework.cloud.gateway.support.NameUtils;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.web.server.ServerWebExchange;

@FunctionalInterface
public interface RoutePredicateFactory<C>
extends ShortcutConfigurable,
Configurable<C> {
    public static final String PATTERN_KEY = "pattern";

    default public Predicate<ServerWebExchange> apply(Consumer<C> consumer) {
        C config = this.newConfig();
        consumer.accept(config);
        this.beforeApply(config);
        return this.apply(config);
    }

    default public AsyncPredicate<ServerWebExchange> applyAsync(Consumer<C> consumer) {
        C config = this.newConfig();
        consumer.accept(config);
        this.beforeApply(config);
        return this.applyAsync(config);
    }

    @Override
    default public Class<C> getConfigClass() {
        throw new UnsupportedOperationException("getConfigClass() not implemented");
    }

    @Override
    default public C newConfig() {
        throw new UnsupportedOperationException("newConfig() not implemented");
    }

    default public void beforeApply(C config) {
    }

    public Predicate<ServerWebExchange> apply(C var1);

    default public AsyncPredicate<ServerWebExchange> applyAsync(C config) {
        return ServerWebExchangeUtils.toAsyncPredicate(this.apply(config));
    }

    default public String name() {
        return NameUtils.normalizeRoutePredicateName(this.getClass());
    }
}

