/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.ratelimit.RedisRateLimiter;
import org.springframework.cloud.gateway.route.RedisRouteDefinitionRepository;
import org.springframework.cloud.gateway.route.RedisRouteDefinitionRepositoryTests;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.test.annotation.DirtiesContext;

public class GatewayRedisAutoConfigurationTests {

    @Nested
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.redis-route-definition-repository.enabled=false"})
    @DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
    class RedisRouteDefinitionRepositoryDisabledByProperty {
        @Autowired(required=false)
        private RedisRouteDefinitionRepository redisRouteDefinitionRepository;

        RedisRouteDefinitionRepositoryDisabledByProperty() {
        }

        @Test
        public void redisRouteDefinitionRepository() {
            Assertions.assertThat((Object)this.redisRouteDefinitionRepository).isNull();
        }
    }

    @Nested
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.redis.enabled=false"})
    class DisabledByProperty {
        @Autowired(required=false)
        private RedisScript redisRequestRateLimiterScript;
        @Autowired(required=false)
        private RedisRateLimiter redisRateLimiter;

        DisabledByProperty() {
        }

        @Test
        public void shouldDisableRedisBeans() {
            Assertions.assertThat((Object)this.redisRequestRateLimiterScript).isNull();
            Assertions.assertThat((Object)this.redisRateLimiter).isNull();
        }
    }

    @Nested
    @SpringBootTest(classes={Config.class})
    class EnabledByDefault {
        @Autowired(required=false)
        private RedisScript redisRequestRateLimiterScript;
        @Autowired(required=false)
        private RedisRateLimiter redisRateLimiter;

        EnabledByDefault() {
        }

        @Test
        public void shouldInjectRedisBeans() {
            Assertions.assertThat((Object)this.redisRequestRateLimiterScript).isNotNull();
            Assertions.assertThat((Object)this.redisRateLimiter).isNotNull();
        }
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    protected static class Config {
        protected Config() {
        }

        @Bean
        RedisRouteDefinitionRepositoryTests.TestGatewayFilterFactory testGatewayFilterFactory() {
            return new RedisRouteDefinitionRepositoryTests.TestGatewayFilterFactory();
        }

        @Bean
        RedisRouteDefinitionRepositoryTests.TestFilterGatewayFilterFactory testFilterGatewayFilterFactory() {
            return new RedisRouteDefinitionRepositoryTests.TestFilterGatewayFilterFactory();
        }

        @Bean
        RedisRouteDefinitionRepositoryTests.TestRoutePredicateFactory testRoutePredicateFactory() {
            return new RedisRouteDefinitionRepositoryTests.TestRoutePredicateFactory();
        }
    }
}

