/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.config.GatewayRedisAutoConfigurationTests;
import org.springframework.cloud.gateway.route.RedisRouteDefinitionRepository;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.DynamicPropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@SpringBootTest(classes={GatewayRedisAutoConfigurationTests.Config.class}, properties={"spring.cloud.gateway.redis-route-definition-repository.enabled=true"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
@Testcontainers
@Tag(value="DockerRequired")
public class GatewayRedisRouteDefinitionRepositoryEnabledByPropertyTests {
    @Container
    public static GenericContainer redis = new GenericContainer("redis:5.0.14-alpine").withExposedPorts(new Integer[]{6379});
    @Autowired(required=false)
    private RedisRouteDefinitionRepository redisRouteDefinitionRepository;

    @BeforeAll
    public static void startRedisContainer() {
        redis.start();
    }

    @DynamicPropertySource
    static void containerProperties(DynamicPropertyRegistry registry) {
        registry.add("spring.redis.host", () -> ((GenericContainer)redis).getContainerIpAddress());
        registry.add("spring.redis.port", () -> ((GenericContainer)redis).getFirstMappedPort());
    }

    @Test
    public void redisRouteDefinitionRepository() {
        Assertions.assertThat((Object)this.redisRouteDefinitionRepository).isNotNull();
    }
}

