/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config.conditional;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.RemoveCachedBodyFilter;
import org.springframework.cloud.gateway.filter.RouteToRequestUrlFilter;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=Enclosed.class)
public class DisableBuiltInGlobalFiltersTests {

    @RunWith(value=SpringRunner.class)
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.global-filter.adapt-cached-body.enabled=false", "spring.cloud.gateway.global-filter.remove-cached-body.enabled=false", "spring.cloud.gateway.global-filter.route-to-request-url.enabled=false", "spring.cloud.gateway.global-filter.forward-routing.enabled=false", "spring.cloud.gateway.global-filter.forward-path.enabled=false", "spring.cloud.gateway.global-filter.websocket-routing.enabled=false", "spring.cloud.gateway.global-filter.netty-write-response.enabled=false", "spring.cloud.gateway.global-filter.netty-routing.enabled=false", "spring.cloud.gateway.global-filter.reactive-load-balancer-client.enabled=false", "spring.cloud.gateway.global-filter.load-balancer-client.enabled=false", "spring.cloud.gateway.global-filter.load-balancer-service-instance-cookie.enabled=false", "spring.cloud.gateway.metrics.enabled=false"})
    @ActiveProfiles(value={"disable-components"})
    public static class DisableAllGlobalFiltersByProperty {
        @Autowired(required=false)
        private List<GlobalFilter> globalFilters;

        @Test
        public void shouldDisableAllBuiltInFilters() {
            Assertions.assertThat(this.globalFilters).isNull();
        }
    }

    @RunWith(value=SpringRunner.class)
    @SpringBootTest(classes={Config.class}, properties={"spring.cloud.gateway.global-filter.remove-cached-body.enabled=false", "spring.cloud.gateway.global-filter.route-to-request-url.enabled=false"})
    @ActiveProfiles(value={"disable-components"})
    public static class DisableSpecificsFiltersByProperty {
        @Autowired
        private List<GlobalFilter> globalFilters;

        @Test
        public void shouldInjectOnlyEnabledBuiltInFilters() {
            Assertions.assertThat(this.globalFilters).hasSizeGreaterThan(0);
            Assertions.assertThat(this.globalFilters).allSatisfy(filter -> {
                ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)filter).isNotInstanceOfAny(new Class[]{RemoveCachedBodyFilter.class, RouteToRequestUrlFilter.class});
            });
        }
    }

    @RunWith(value=SpringRunner.class)
    @SpringBootTest(classes={Config.class})
    public static class GlobalFilterDefault {
        @Autowired
        private List<GlobalFilter> globalFilters;

        @Test
        public void shouldInjectBuiltInFilters() {
            Assertions.assertThat(this.globalFilters).hasSizeGreaterThanOrEqualTo(10);
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    protected static class Config {
        protected Config() {
        }
    }
}

