/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config.conditional;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.config.conditional.OnEnabledPredicate;
import org.springframework.cloud.gateway.handler.predicate.AfterRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.CloudFoundryRouteServiceRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.ReadBodyRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.RemoteAddrRoutePredicateFactory;

class OnEnabledPredicateTests {
    private OnEnabledPredicate onEnabledPredicate;

    OnEnabledPredicateTests() {
    }

    @BeforeEach
    void setUp() {
        this.onEnabledPredicate = new OnEnabledPredicate();
    }

    @Test
    void shouldNormalizePredicatesNames() {
        List<Class> predicates = Arrays.asList(AfterRoutePredicateFactory.class, CloudFoundryRouteServiceRoutePredicateFactory.class, ReadBodyRoutePredicateFactory.class, RemoteAddrRoutePredicateFactory.class);
        List resultNames = predicates.stream().map(arg_0 -> ((OnEnabledPredicate)this.onEnabledPredicate).normalizeComponentName(arg_0)).collect(Collectors.toList());
        List expectedNames = Stream.of("after", "cloud-foundry-route-service", "read-body", "remote-addr").map(s -> "predicate." + s).collect(Collectors.toList());
        Assertions.assertThat(resultNames).isEqualTo(expectedNames);
    }
}

