/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.gateway.config.GatewayLoadBalancerProperties;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.ReactiveLoadBalancerClientFilter;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.RoundRobinLoadBalancer;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.loadbalancer.support.ServiceInstanceListSuppliers;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@ExtendWith(value={MockitoExtension.class})
class ReactiveLoadBalancerClientFilterTests {
    private ServerWebExchange exchange;
    private GatewayLoadBalancerProperties properties;
    @Mock
    private GatewayFilterChain chain;
    @Mock
    private LoadBalancerClientFactory clientFactory;
    @Mock
    private LoadBalancerProperties loadBalancerProperties;
    @InjectMocks
    private ReactiveLoadBalancerClientFilter filter;

    ReactiveLoadBalancerClientFilterTests() {
    }

    @BeforeEach
    void setup() {
        this.properties = new GatewayLoadBalancerProperties();
        this.exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)"/mypath", (Object[])new Object[0]).build());
    }

    @Test
    void shouldNotFilterWhenGatewayRequestUrlIsMissing() {
        this.filter.filter(this.exchange, this.chain);
        ((GatewayFilterChain)Mockito.verify((Object)this.chain)).filter(this.exchange);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.chain});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.clientFactory});
    }

    @Test
    void shouldNotFilterWhenGatewayRequestUrlSchemeIsNotLb() {
        URI uri = UriComponentsBuilder.fromUriString((String)"http://myservice").build().toUri();
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
        this.filter.filter(this.exchange, this.chain);
        ((GatewayFilterChain)Mockito.verify((Object)this.chain)).filter(this.exchange);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.chain});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.clientFactory});
    }

    @Test
    void shouldThrowExceptionWhenNoServiceInstanceIsFound() {
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        Assertions.assertThatExceptionOfType(NotFoundException.class).isThrownBy(() -> {
            URI uri = UriComponentsBuilder.fromUriString((String)"lb://myservice").build().toUri();
            this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
            this.filter.filter(this.exchange, this.chain).block();
        });
    }

    @Test
    void shouldFilter() {
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        URI url = UriComponentsBuilder.fromUriString((String)"lb://myservice").build().toUri();
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, url);
        DefaultServiceInstance serviceInstance = new DefaultServiceInstance("myservice1", "myservice", "localhost", 8080, true);
        RoundRobinLoadBalancer loadBalancer = new RoundRobinLoadBalancer(ServiceInstanceListSuppliers.toProvider((String)"myservice", (ServiceInstance[])new ServiceInstance[]{serviceInstance}), "myservice", -1);
        Mockito.when((Object)this.clientFactory.getInstance("myservice", ReactorServiceInstanceLoadBalancer.class)).thenReturn((Object)loadBalancer);
        Mockito.when((Object)this.chain.filter(this.exchange)).thenReturn((Object)Mono.empty());
        this.filter.filter(this.exchange, this.chain).block();
        Assertions.assertThat((Collection)((LinkedHashSet)this.exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR))).contains((Object[])new URI[]{url});
        ((LoadBalancerClientFactory)Mockito.verify((Object)this.clientFactory)).getInstance("myservice", ReactorServiceInstanceLoadBalancer.class);
        ((LoadBalancerClientFactory)Mockito.verify((Object)this.clientFactory)).getInstances("myservice", LoadBalancerLifecycle.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.clientFactory});
        Assertions.assertThat((URI)((URI)this.exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR))).isEqualTo((Object)URI.create("https://localhost:8080/mypath"));
        ((GatewayFilterChain)Mockito.verify((Object)this.chain)).filter(this.exchange);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.chain});
    }

    @Test
    void happyPath() {
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/get?a=b", (Object[])new Object[0]).build();
        URI lbUri = URI.create("lb://service1?a=b");
        ServerWebExchange webExchange = this.testFilter(request, lbUri);
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("http").hasHost("service1-host1").hasParameter("a", "b");
    }

    @Test
    void noQueryParams() {
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]).build();
        ServerWebExchange webExchange = this.testFilter(request, URI.create("lb://service1"));
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("http").hasHost("service1-host1");
    }

    @Test
    void encodedParameters() {
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        URI url = UriComponentsBuilder.fromUriString((String)"http://localhost/get?a=b&c=d[]").buildAndExpand(new Object[0]).encode().toUri();
        MockServerHttpRequest request = MockServerHttpRequest.method((HttpMethod)HttpMethod.GET, (URI)url).build();
        URI lbUrl = UriComponentsBuilder.fromUriString((String)"lb://service1?a=b&c=d[]").buildAndExpand(new Object[0]).encode().toUri();
        Assertions.assertThat((String)lbUrl.getRawQuery()).isEqualTo("a=b&c=d%5B%5D");
        Assertions.assertThat((URI)lbUrl).hasParameter("c", "d[]");
        ServerWebExchange webExchange = this.testFilter(request, lbUrl);
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("http").hasHost("service1-host1").hasParameter("a", "b").hasParameter("c", "d[]");
        Assertions.assertThat((String)uri.getRawQuery()).isEqualTo("a=b&c=d%5B%5D");
    }

    @Test
    void unencodedParameters() {
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        URI url = URI.create("http://localhost/get?a=b&c=d[]");
        MockServerHttpRequest request = MockServerHttpRequest.method((HttpMethod)HttpMethod.GET, (URI)url).build();
        URI lbUrl = URI.create("lb://service1?a=b&c=d[]");
        Assertions.assertThat((String)lbUrl.getRawQuery()).isEqualTo("a=b&c=d[]");
        ServerWebExchange webExchange = this.testFilter(request, lbUrl);
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("http").hasHost("service1-host1").hasParameter("a", "b").hasParameter("c", "d[]");
        Assertions.assertThat((String)uri.getRawQuery()).isEqualTo("a=b&c=d[]");
    }

    @Test
    void happyPathWithAttributeRatherThanScheme() {
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"ws://localhost/get?a=b", (Object[])new Object[0]).build();
        URI lbUri = URI.create("ws://service1?a=b");
        this.exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_SCHEME_PREFIX_ATTR, "lb");
        ServerWebExchange webExchange = this.testFilter(this.exchange, lbUri);
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("ws").hasHost("service1-host1").hasParameter("a", "b");
    }

    @Test
    void shouldNotFilterWhenGatewaySchemePrefixAttrIsNotLb() {
        URI uri = UriComponentsBuilder.fromUriString((String)"http://myservice").build().toUri();
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_SCHEME_PREFIX_ATTR, "xx");
        this.filter.filter(this.exchange, this.chain);
        ((GatewayFilterChain)Mockito.verify((Object)this.chain)).filter(this.exchange);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.chain});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.clientFactory});
    }

    @Test
    void shouldThrow4O4ExceptionWhenNoServiceInstanceIsFound() {
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        URI uri = UriComponentsBuilder.fromUriString((String)"lb://service1").build().toUri();
        this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
        RoundRobinLoadBalancer loadBalancer = new RoundRobinLoadBalancer(ServiceInstanceListSuppliers.toProvider((String)"service1", (ServiceInstance[])new ServiceInstance[0]), "service1", -1);
        Mockito.when((Object)this.clientFactory.getInstance("service1", ReactorServiceInstanceLoadBalancer.class)).thenReturn((Object)loadBalancer);
        this.properties.setUse404(true);
        ReactiveLoadBalancerClientFilter filter = new ReactiveLoadBalancerClientFilter(this.clientFactory, this.properties, this.loadBalancerProperties);
        Mockito.when((Object)this.chain.filter(this.exchange)).thenReturn((Object)Mono.empty());
        try {
            filter.filter(this.exchange, this.chain).block();
        }
        catch (NotFoundException exception) {
            Assertions.assertThat((Comparable)exception.getStatus()).isEqualTo((Object)HttpStatus.NOT_FOUND);
        }
    }

    @Test
    void shouldOverrideSchemeUsingIsSecure() {
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        URI url = UriComponentsBuilder.fromUriString((String)"lb://myservice").build().toUri();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)"https://localhost:9999/mypath", (Object[])new Object[0]).build());
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, url);
        DefaultServiceInstance serviceInstance = new DefaultServiceInstance("myservice1", "myservice", "localhost", 8080, false);
        Mockito.when((Object)this.clientFactory.getInstance("myservice", ReactorServiceInstanceLoadBalancer.class)).thenReturn((Object)new RoundRobinLoadBalancer(ServiceInstanceListSuppliers.toProvider((String)"myservice", (ServiceInstance[])new ServiceInstance[]{serviceInstance}), "myservice", -1));
        Mockito.when((Object)this.chain.filter((ServerWebExchange)exchange)).thenReturn((Object)Mono.empty());
        this.filter.filter((ServerWebExchange)exchange, this.chain).block();
        Assertions.assertThat((Collection)((LinkedHashSet)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR))).contains((Object[])new URI[]{url});
        Assertions.assertThat((URI)((URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR))).isEqualTo((Object)URI.create("http://localhost:8080/mypath"));
        ((GatewayFilterChain)Mockito.verify((Object)this.chain)).filter((ServerWebExchange)exchange);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.chain});
    }

    @Test
    void shouldPassRequestToLoadBalancer() {
        String hint = "test";
        Mockito.when((Object)this.loadBalancerProperties.getHint()).thenReturn(this.buildHints(hint));
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/get?a=b", (Object[])new Object[0]).build();
        URI lbUri = URI.create("lb://service1?a=b");
        ServerWebExchange serverWebExchange = (ServerWebExchange)Mockito.mock(ServerWebExchange.class);
        Mockito.when((Object)serverWebExchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR)).thenReturn((Object)lbUri);
        Mockito.when((Object)serverWebExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR)).thenReturn(new LinkedHashSet());
        Mockito.when((Object)serverWebExchange.getRequest()).thenReturn((Object)request);
        RoundRobinLoadBalancer loadBalancer = (RoundRobinLoadBalancer)Mockito.mock(RoundRobinLoadBalancer.class);
        Mockito.when((Object)loadBalancer.choose((Request)ArgumentMatchers.any(Request.class))).thenReturn((Object)Mono.just((Object)new DefaultResponse((ServiceInstance)new DefaultServiceInstance("myservice1", "service1", "localhost", 8080, false))));
        Mockito.when((Object)this.clientFactory.getInstance("service1", ReactorServiceInstanceLoadBalancer.class)).thenReturn((Object)loadBalancer);
        Mockito.when((Object)this.chain.filter((ServerWebExchange)ArgumentMatchers.any())).thenReturn((Object)Mono.empty());
        this.filter.filter(serverWebExchange, this.chain);
        ((RoundRobinLoadBalancer)Mockito.verify((Object)loadBalancer)).choose((Request)ArgumentMatchers.argThat(passedRequest -> ((RequestDataContext)passedRequest.getContext()).getClientRequest().getUrl().equals(request.getURI()) && ((RequestDataContext)passedRequest.getContext()).getHint().equals(hint)));
    }

    @Test
    void loadBalancerLifecycleCallbacksExecutedForSuccess() {
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        LoadBalancerLifecycle lifecycleProcessor = (LoadBalancerLifecycle)Mockito.mock(LoadBalancerLifecycle.class);
        DefaultServiceInstance serviceInstance = new DefaultServiceInstance("myservice1", "myservice", "localhost", 8080, false);
        ServerWebExchange serverWebExchange = this.mockExchange((ServiceInstance)serviceInstance, lifecycleProcessor, false);
        this.filter.filter(serverWebExchange, this.chain).subscribe();
        ((LoadBalancerLifecycle)Mockito.verify((Object)lifecycleProcessor)).onStart((Request)ArgumentMatchers.any(Request.class));
        ((LoadBalancerLifecycle)Mockito.verify((Object)lifecycleProcessor)).onStartRequest((Request)ArgumentMatchers.any(Request.class), (Response)ArgumentMatchers.any(Response.class));
        ((LoadBalancerLifecycle)Mockito.verify((Object)lifecycleProcessor)).onComplete((CompletionContext)ArgumentMatchers.argThat(arg_0 -> ReactiveLoadBalancerClientFilterTests.lambda$loadBalancerLifecycleCallbacksExecutedForSuccess$2((ServiceInstance)serviceInstance, arg_0)));
    }

    @Test
    void loadBalancerLifecycleCallbacksExecutedForDiscard() {
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        LoadBalancerLifecycle lifecycleProcessor = (LoadBalancerLifecycle)Mockito.mock(LoadBalancerLifecycle.class);
        ServiceInstance serviceInstance = null;
        ServerWebExchange serverWebExchange = this.mockExchange(serviceInstance, lifecycleProcessor, false);
        this.filter.filter(serverWebExchange, this.chain).subscribe();
        ((LoadBalancerLifecycle)Mockito.verify((Object)lifecycleProcessor)).onStart((Request)ArgumentMatchers.any(Request.class));
        ((LoadBalancerLifecycle)Mockito.verify((Object)lifecycleProcessor)).onComplete((CompletionContext)ArgumentMatchers.argThat(completionContext -> CompletionContext.Status.DISCARD.equals((Object)completionContext.status()) && HttpMethod.GET.equals((Object)((RequestDataContext)completionContext.getLoadBalancerRequest().getContext()).method())));
    }

    @Test
    void loadBalancerLifecycleCallbacksExecutedForFailed() {
        Mockito.when((Object)this.clientFactory.getProperties((String)ArgumentMatchers.any())).thenReturn((Object)this.loadBalancerProperties);
        LoadBalancerLifecycle lifecycleProcessor = (LoadBalancerLifecycle)Mockito.mock(LoadBalancerLifecycle.class);
        DefaultServiceInstance serviceInstance = new DefaultServiceInstance("myservice1", "myservice", "localhost", 8080, false);
        ServerWebExchange serverWebExchange = this.mockExchange((ServiceInstance)serviceInstance, lifecycleProcessor, true);
        this.filter.filter(serverWebExchange, this.chain).subscribe();
        ((LoadBalancerLifecycle)Mockito.verify((Object)lifecycleProcessor)).onStart((Request)ArgumentMatchers.any(Request.class));
        ((LoadBalancerLifecycle)Mockito.verify((Object)lifecycleProcessor)).onStartRequest((Request)ArgumentMatchers.any(Request.class), (Response)ArgumentMatchers.any(Response.class));
        ((LoadBalancerLifecycle)Mockito.verify((Object)lifecycleProcessor)).onComplete((CompletionContext)ArgumentMatchers.argThat(completionContext -> CompletionContext.Status.FAILED.equals((Object)completionContext.status()) && HttpMethod.GET.equals((Object)((RequestDataContext)completionContext.getLoadBalancerRequest().getContext()).method())));
    }

    private ServerWebExchange mockExchange(ServiceInstance serviceInstance, LoadBalancerLifecycle lifecycleProcessor, boolean shouldThrowException) {
        Mockito.when((Object)lifecycleProcessor.supports((Class)ArgumentMatchers.any(Class.class), (Class)ArgumentMatchers.any(Class.class), (Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)true);
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/get?a=b", (Object[])new Object[0]).build();
        URI lbUri = URI.create("lb://service1?a=b");
        MockServerWebExchange serverWebExchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        Object response = serviceInstance == null ? new EmptyResponse() : new DefaultResponse(serviceInstance);
        serverWebExchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, lbUri);
        serverWebExchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR, new LinkedHashSet());
        serverWebExchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR, response);
        RoundRobinLoadBalancer loadBalancer = (RoundRobinLoadBalancer)Mockito.mock(RoundRobinLoadBalancer.class);
        Mockito.when((Object)loadBalancer.choose((Request)ArgumentMatchers.any(Request.class))).thenReturn((Object)Mono.just((Object)response));
        Mockito.when((Object)this.clientFactory.getInstance("service1", ReactorServiceInstanceLoadBalancer.class)).thenReturn((Object)loadBalancer);
        HashMap<String, LoadBalancerLifecycle> lifecycleProcessors = new HashMap<String, LoadBalancerLifecycle>();
        lifecycleProcessors.put("service1", lifecycleProcessor);
        Mockito.when((Object)this.clientFactory.getInstances("service1", LoadBalancerLifecycle.class)).thenReturn(lifecycleProcessors);
        if (shouldThrowException) {
            Mockito.when((Object)this.chain.filter((ServerWebExchange)ArgumentMatchers.any())).thenReturn((Object)Mono.error((Throwable)new UnsupportedOperationException()));
        } else {
            Mockito.when((Object)this.chain.filter((ServerWebExchange)ArgumentMatchers.any())).thenReturn((Object)Mono.empty());
        }
        return serverWebExchange;
    }

    @NotNull
    private Map<String, String> buildHints(String hint) {
        HashMap<String, String> hints = new HashMap<String, String>();
        hints.put("default", hint);
        return hints;
    }

    private ServerWebExchange testFilter(MockServerHttpRequest request, URI uri) {
        return this.testFilter((ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request), uri);
    }

    private ServerWebExchange testFilter(ServerWebExchange exchange, URI uri) {
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)this.chain.filter((ServerWebExchange)captor.capture())).thenReturn((Object)Mono.empty());
        RoundRobinLoadBalancer loadBalancer = new RoundRobinLoadBalancer(ServiceInstanceListSuppliers.toProvider((String)"service1", (ServiceInstance[])new ServiceInstance[]{new DefaultServiceInstance("service1_1", "service1", "service1-host1", 8081, false)}), "service1", -1);
        Mockito.when((Object)this.clientFactory.getInstance("service1", ReactorServiceInstanceLoadBalancer.class)).thenReturn((Object)loadBalancer);
        ReactiveLoadBalancerClientFilter filter = new ReactiveLoadBalancerClientFilter(this.clientFactory, this.properties, this.loadBalancerProperties);
        filter.filter(exchange, this.chain).block();
        return (ServerWebExchange)captor.getValue();
    }

    private static /* synthetic */ boolean lambda$loadBalancerLifecycleCallbacksExecutedForSuccess$2(ServiceInstance serviceInstance, CompletionContext completionContext) {
        return CompletionContext.Status.SUCCESS.equals((Object)completionContext.status()) && completionContext.getLoadBalancerResponse().getServer().equals(serviceInstance) && HttpMethod.GET.equals((Object)((RequestDataContext)completionContext.getLoadBalancerRequest().getContext()).method());
    }
}

