/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnJre;
import org.junit.jupiter.api.condition.JRE;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.event.PredicateArgsEvent;
import org.springframework.cloud.gateway.filter.WeightCalculatorWebFilter;
import org.springframework.cloud.gateway.support.ConfigurationService;
import org.springframework.cloud.gateway.support.WeightConfig;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;

public class WeightCalculatorWebFilterTests {
    @Test
    public void testWeightCalculation() {
        WeightCalculatorWebFilter filter = this.createFilter();
        String grp1 = "group1";
        String grp2 = "group2";
        int grp1idx = 1;
        int grp2idx = 1;
        this.assertWeightCalculation(filter, grp1, grp1idx++, 1, Arrays.asList(1.0), new Double[0]);
        this.assertWeightCalculation(filter, grp2, grp2idx++, 1, Arrays.asList(1.0), new Double[0]);
        this.assertWeightCalculation(filter, grp1, grp1idx++, 3, Arrays.asList(0.25, 0.75), 0.25);
        this.assertWeightCalculation(filter, grp2, grp2idx++, 1, Arrays.asList(0.5, 0.5), 0.5);
        this.assertWeightCalculation(filter, grp1, grp1idx++, 6, Arrays.asList(0.1, 0.3, 0.6), 0.1, 0.4);
        this.assertWeightCalculation(filter, grp2, grp2idx++, 2, Arrays.asList(0.25, 0.25, 0.5), 0.25, 0.5);
        this.assertWeightCalculation(filter, grp2, grp2idx++, 4, Arrays.asList(0.125, 0.125, 0.25, 0.5), 0.125, 0.25, 0.5);
    }

    private WeightCalculatorWebFilter createFilter() {
        return new WeightCalculatorWebFilter(null, new ConfigurationService(null, () -> null, () -> null));
    }

    private void assertWeightCalculation(WeightCalculatorWebFilter filter, String group, int item, int weight, List<Double> normalized, Double ... middleRanges) {
        int i;
        String routeId = this.route(item);
        filter.addWeightConfig(new WeightConfig(group, routeId, weight));
        Map groupWeights = filter.getGroupWeights();
        Assertions.assertThat((Map)groupWeights).containsKey((Object)group);
        WeightCalculatorWebFilter.GroupWeightConfig config = (WeightCalculatorWebFilter.GroupWeightConfig)groupWeights.get(group);
        Assertions.assertThat((String)config.group).isEqualTo(group);
        ((MapAssert)Assertions.assertThat((Map)config.weights).hasSize(item)).containsEntry((Object)routeId, (Object)weight);
        Assertions.assertThat((Map)config.normalizedWeights).hasSize(item);
        for (i = 0; i < normalized.size(); ++i) {
            Assertions.assertThat((Map)config.normalizedWeights).containsEntry((Object)this.route(i + 1), (Object)normalized.get(i));
        }
        for (i = 0; i < normalized.size(); ++i) {
            Assertions.assertThat((Map)config.rangeIndexes).containsEntry((Object)i, (Object)this.route(i + 1));
        }
        ((ListAssert)((ListAssert)Assertions.assertThat((List)config.ranges).hasSize(item + 1)).startsWith((Object[])new Double[]{0.0})).endsWith((Object)1.0, (Object[])new Double[0]);
        if (middleRanges.length > 0) {
            Assertions.assertThat((List)config.ranges).contains((Object[])middleRanges);
        }
    }

    @NotNull
    private String route(int i) {
        return "route" + i;
    }

    @Test
    @DisabledOnJre(value={JRE.JAVA_17})
    public void testChooseRouteWithRandom() {
        WeightCalculatorWebFilter filter = this.createFilter();
        filter.addWeightConfig(new WeightConfig("groupa", "route1", 1));
        filter.addWeightConfig(new WeightConfig("groupa", "route2", 3));
        filter.addWeightConfig(new WeightConfig("groupa", "route3", 6));
        Random random = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)0.05).thenReturn((Object)0.2).thenReturn((Object)0.6);
        filter.setRandom(random);
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)"http://localhost", (Object[])new Object[0]).build());
        WebFilterChain filterChain = (WebFilterChain)Mockito.mock(WebFilterChain.class);
        filter.filter((ServerWebExchange)exchange, filterChain);
        Map weights = WeightCalculatorWebFilter.getWeights((ServerWebExchange)exchange);
        Assertions.assertThat((Map)weights).containsEntry((Object)"groupa", (Object)"route1");
        filter.filter((ServerWebExchange)exchange, filterChain);
        weights = WeightCalculatorWebFilter.getWeights((ServerWebExchange)exchange);
        Assertions.assertThat((Map)weights).containsEntry((Object)"groupa", (Object)"route2");
        filter.filter((ServerWebExchange)exchange, filterChain);
        weights = WeightCalculatorWebFilter.getWeights((ServerWebExchange)exchange);
        Assertions.assertThat((Map)weights).containsEntry((Object)"groupa", (Object)"route3");
    }

    @Test
    public void receivesPredicateArgsEvent() {
        TestWeightCalculatorWebFilter filter = new TestWeightCalculatorWebFilter();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("weight.group", "group1");
        args.put("weight.weight", "1");
        PredicateArgsEvent event = new PredicateArgsEvent((Object)this, "routeA", args);
        filter.handle(event);
        WeightConfig weightConfig = filter.weightConfig;
        Assertions.assertThat((String)weightConfig.getGroup()).isEqualTo("group1");
        Assertions.assertThat((String)weightConfig.getRouteId()).isEqualTo("routeA");
        Assertions.assertThat((int)weightConfig.getWeight()).isEqualTo(1);
    }

    class TestWeightCalculatorWebFilter
    extends WeightCalculatorWebFilter {
        private WeightConfig weightConfig;

        TestWeightCalculatorWebFilter() {
            super(null, new ConfigurationService(null, () -> null, () -> null));
        }

        void addWeightConfig(WeightConfig weightConfig) {
            this.weightConfig = weightConfig;
        }
    }
}

