/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
class DedupeResponseHeaderGatewayFilterFactoryTests
extends BaseWebClientTests {
    DedupeResponseHeaderGatewayFilterFactoryTests() {
    }

    @Test
    void dedupeResponseHeaderFilterWorks() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.deduperesponseheader.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("Access-Control-Allow-Credentials", new String[]{"true"}).expectHeader().valueEquals("Access-Control-Allow-Origin", new String[]{"https://musk.mars"}).expectHeader().valueEquals("Scout-Cookie", new String[]{"S'mores"}).expectHeader().valueEquals("Next-Week-Lottery-Numbers", new String[]{"4", "2", "42"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    static class TestConfig {
        TestConfig() {
        }
    }
}

