/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.DedupeResponseHeaderGatewayFilterFactory;
import org.springframework.http.HttpHeaders;

public class DedupeResponseHeaderGatewayFilterFactoryUnitTests {
    private static final String NAME_1 = "Access-Control-Allow-Origin";
    private static final String NAME_2 = "Access-Control-Allow-Credentials";
    private HttpHeaders headers;
    private DedupeResponseHeaderGatewayFilterFactory.Config config;
    private DedupeResponseHeaderGatewayFilterFactory filter;

    @Before
    public void setUp() {
        this.headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        this.config = new DedupeResponseHeaderGatewayFilterFactory.Config();
        this.filter = new DedupeResponseHeaderGatewayFilterFactory();
    }

    @Test
    public void dedupNullName() {
        this.filter.dedupe(this.headers, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.headers, (VerificationMode)Mockito.never())).get((Object)Mockito.anyString());
        ((HttpHeaders)Mockito.verify((Object)this.headers, (VerificationMode)Mockito.never())).set(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void dedupNullValues() {
        this.config.setName(NAME_1);
        Mockito.when((Object)this.headers.get((Object)NAME_1)).thenReturn(null);
        this.filter.dedupe(this.headers, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.headers)).get((Object)NAME_1);
        ((HttpHeaders)Mockito.verify((Object)this.headers, (VerificationMode)Mockito.never())).set(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void dedupEmptyValues() {
        this.config.setName(NAME_1);
        Mockito.when((Object)this.headers.get((Object)NAME_1)).thenReturn(new ArrayList());
        this.filter.dedupe(this.headers, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.headers)).get((Object)NAME_1);
        ((HttpHeaders)Mockito.verify((Object)this.headers, (VerificationMode)Mockito.never())).set(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void dedupSingleValue() {
        this.config.setName(NAME_1);
        Mockito.when((Object)this.headers.get((Object)NAME_1)).thenReturn(Arrays.asList("1"));
        this.filter.dedupe(this.headers, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.headers)).get((Object)NAME_1);
        ((HttpHeaders)Mockito.verify((Object)this.headers, (VerificationMode)Mockito.never())).set(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void dedupMultipleValuesRetainFirst() {
        this.config.setName("Access-Control-Allow-Origin Access-Control-Allow-Credentials");
        Mockito.when((Object)this.headers.get((Object)NAME_1)).thenReturn(Arrays.asList("2", "3", "3", "4"));
        Mockito.when((Object)this.headers.get((Object)NAME_2)).thenReturn(Arrays.asList("true", "false"));
        this.filter.dedupe(this.headers, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.headers)).get((Object)NAME_1);
        ((HttpHeaders)Mockito.verify((Object)this.headers)).set(NAME_1, "2");
        ((HttpHeaders)Mockito.verify((Object)this.headers)).get((Object)NAME_2);
        ((HttpHeaders)Mockito.verify((Object)this.headers)).set(NAME_2, "true");
        ((HttpHeaders)Mockito.verify((Object)this.headers, (VerificationMode)Mockito.times((int)2))).set(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void dedupMultipleValuesRetainLast() {
        this.config.setName(NAME_1);
        this.config.setStrategy(DedupeResponseHeaderGatewayFilterFactory.Strategy.RETAIN_LAST);
        Mockito.when((Object)this.headers.get((Object)NAME_1)).thenReturn(Arrays.asList("2", "3", "3", "4"));
        this.filter.dedupe(this.headers, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.headers)).get((Object)NAME_1);
        ((HttpHeaders)Mockito.verify((Object)this.headers)).set(NAME_1, "4");
        ((HttpHeaders)Mockito.verify((Object)this.headers)).set(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void dedupMultipleValuesRetainUnique() {
        this.config.setName(NAME_1);
        this.config.setStrategy(DedupeResponseHeaderGatewayFilterFactory.Strategy.RETAIN_UNIQUE);
        Mockito.when((Object)this.headers.get((Object)NAME_1)).thenReturn(Arrays.asList("2", "3", "3", "4"));
        this.filter.dedupe(this.headers, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.headers)).get((Object)NAME_1);
        ((HttpHeaders)Mockito.verify((Object)this.headers)).put((String)Mockito.eq((Object)NAME_1), (List)Mockito.eq(Arrays.asList("2", "3", "4")));
        ((HttpHeaders)Mockito.verify((Object)this.headers)).put(Mockito.anyString(), Mockito.anyList());
    }

    @Test
    public void toStringFormat() {
        DedupeResponseHeaderGatewayFilterFactory.Config config = new DedupeResponseHeaderGatewayFilterFactory.Config();
        config.setName("myname");
        config.setStrategy(DedupeResponseHeaderGatewayFilterFactory.Strategy.RETAIN_LAST);
        GatewayFilter filter = new DedupeResponseHeaderGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myname"})).contains(new CharSequence[]{DedupeResponseHeaderGatewayFilterFactory.Strategy.RETAIN_LAST.toString()});
    }
}

