/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.RedirectToGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class RedirectToGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Test
    public void redirectToFilterWorks() {
        this.testClient.get().uri("/", new Object[0]).header("Host", new String[]{"www.redirectto.org"}).exchange().expectStatus().isEqualTo(HttpStatus.FOUND).expectHeader().valueEquals("Location", new String[]{"https://example.org"});
    }

    @Test
    public void redirectToRelativeUrlFilterWorks() {
        this.testClient.get().uri("/", new Object[0]).header("Host", new String[]{"www.relativeredirect.org"}).exchange().expectStatus().isEqualTo(HttpStatus.FOUND).expectHeader().valueEquals("Location", new String[]{"/index.html#/customers"});
    }

    @Test
    public void toStringFormat() {
        RedirectToGatewayFilterFactory.Config config = new RedirectToGatewayFilterFactory.Config();
        config.setStatus("301");
        config.setUrl("http://newurl");
        GatewayFilter filter = new RedirectToGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"301"})).contains(new CharSequence[]{"http://newurl"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("relative_redirect", r -> r.host(new String[]{"**.relativeredirect.org"}).filters(f -> f.redirect(302, "/index.html#/customers")).uri("no://op")).build();
        }
    }
}

