/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveRequestParameterGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class RemoveRequestParameterGatewayFilterFactoryIntegrationTests
extends BaseWebClientTests {
    @Test
    public void removeResponseHeaderFilterWorks() {
        this.testClient.get().uri("/get?foo=bar&baz=bam%20bar", new Object[0]).header("Host", new String[]{"www.removerequestparamjava.org"}).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> params = TestUtils.getMap((Map)result.getResponseBody(), "args");
            Assertions.assertThat(params).doesNotContainKey((Object)"foo");
            Assertions.assertThat(params).containsEntry((Object)"baz", (Object)"bam%20bar");
        });
    }

    @Test
    public void toStringFormat() {
        AbstractGatewayFilterFactory.NameConfig config = new AbstractGatewayFilterFactory.NameConfig();
        config.setName("myname");
        GatewayFilter filter = new RemoveRequestParameterGatewayFilterFactory().apply(config);
        Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myname"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("removerequestparam_java_test", r -> r.path(new String[]{"/get"}).and().host(new String[]{"**.removerequestparamjava.org"}).filters(f -> f.prefixPath("/httpbin").removeRequestParameter("foo")).uri(this.uri)).build();
        }
    }
}

