/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestHeaderToRequestUriGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RequestHeaderToRequestUriGatewayFilterFactoryTests {
    @Test
    public void filterChangeRequestUri() {
        RequestHeaderToRequestUriGatewayFilterFactory factory = new RequestHeaderToRequestUriGatewayFilterFactory();
        GatewayFilter filter = factory.apply(c -> c.setName("X-CF-Forwarded-Url"));
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost", (Object[])new Object[0]).header("X-CF-Forwarded-Url", new String[]{"https://example.com"}).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, URI.create("http://localhost"));
        GatewayFilterChain filterChain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)filterChain.filter((ServerWebExchange)captor.capture())).thenReturn((Object)Mono.empty());
        filter.filter((ServerWebExchange)exchange, filterChain);
        ServerWebExchange webExchange = (ServerWebExchange)captor.getValue();
        URI uri = (URI)webExchange.getAttributes().get(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).isNotNull();
        Assertions.assertThat((String)uri.toString()).isEqualTo("https://example.com");
    }

    @Test
    public void filterDoesNotChangeRequestUriIfHeaderIsAbsent() {
        RequestHeaderToRequestUriGatewayFilterFactory factory = new RequestHeaderToRequestUriGatewayFilterFactory();
        GatewayFilter filter = factory.apply(c -> c.setName("X-CF-Forwarded-Url"));
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost", (Object[])new Object[0]).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, URI.create("http://localhost"));
        GatewayFilterChain filterChain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)filterChain.filter((ServerWebExchange)captor.capture())).thenReturn((Object)Mono.empty());
        filter.filter((ServerWebExchange)exchange, filterChain);
        ServerWebExchange webExchange = (ServerWebExchange)captor.getValue();
        URI uri = (URI)webExchange.getAttributes().get(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).isNotNull();
        Assertions.assertThat((String)uri.toString()).isEqualTo("http://localhost");
    }

    @Test
    public void filterDoesNotChangeRequestUriIfHeaderIsInvalid() throws Exception {
        RequestHeaderToRequestUriGatewayFilterFactory factory = new RequestHeaderToRequestUriGatewayFilterFactory();
        GatewayFilter filter = factory.apply(c -> c.setName("X-CF-Forwarded-Url"));
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost", (Object[])new Object[0]).header("X-CF-Forwarded-Url", new String[]{"example"}).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, URI.create("http://localhost"));
        GatewayFilterChain filterChain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)filterChain.filter((ServerWebExchange)captor.capture())).thenReturn((Object)Mono.empty());
        filter.filter((ServerWebExchange)exchange, filterChain);
        ServerWebExchange webExchange = (ServerWebExchange)captor.getValue();
        URI uri = (URI)webExchange.getAttributes().get(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).isNotNull();
        Assertions.assertThat((String)uri.toURL().toString()).isEqualTo("http://localhost");
    }

    @Test
    public void toStringFormat() {
        AbstractGatewayFilterFactory.NameConfig config = new AbstractGatewayFilterFactory.NameConfig();
        config.setName("myname");
        GatewayFilter filter = new RequestHeaderToRequestUriGatewayFilterFactory().apply(config);
        Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myname"});
    }
}

