/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.StripPrefixGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class StripPrefixGatewayFilterFactoryTests {
    @Test
    public void testStripPrefix() {
        this.testStripPrefixFilter("/foo/bar", "/bar", 1);
        this.testStripPrefixFilter("/foo/bar", "/", 2);
        this.testStripPrefixFilter("/foo/bar", "/foo/bar", 0);
        this.testStripPrefixFilter("/foo/bar/", "/", 2);
        this.testStripPrefixFilter("/foo/bar/", "/foo/bar/", 0);
        this.testStripPrefixFilter("", "/", 1);
        this.testStripPrefixFilter("/", "/", 1);
        this.testStripPrefixFilter("/", "/", 2);
        this.testStripPrefixFilter("", "/", 2);
        this.testStripPrefixFilter("/this/is/a/long/path/with/a/lot/of/slashes", "/path/with/a/lot/of/slashes", 4);
    }

    private void testStripPrefixFilter(String actualPath, String expectedPath, int parts) {
        GatewayFilter filter = new StripPrefixGatewayFilterFactory().apply(c -> c.setParts(parts));
        MockServerHttpRequest request = MockServerHttpRequest.get((String)("http://localhost" + actualPath), (Object[])new Object[0]).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        GatewayFilterChain filterChain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)filterChain.filter((ServerWebExchange)captor.capture())).thenReturn((Object)Mono.empty());
        filter.filter((ServerWebExchange)exchange, filterChain);
        ServerWebExchange webExchange = (ServerWebExchange)captor.getValue();
        Assertions.assertThat((URI)webExchange.getRequest().getURI()).hasPath(expectedPath);
        URI requestUrl = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)requestUrl).hasScheme("http").hasHost("localhost").hasNoPort().hasPath(expectedPath);
        LinkedHashSet uris = (LinkedHashSet)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
        Assertions.assertThat((Collection)uris).contains((Object[])new URI[]{request.getURI()});
    }

    @Test
    public void toStringFormat() {
        StripPrefixGatewayFilterFactory.Config config = new StripPrefixGatewayFilterFactory.Config();
        config.setParts(2);
        GatewayFilter filter = new StripPrefixGatewayFilterFactory().apply(config);
        Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"2"});
    }
}

