/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.rewrite;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.BodyInserters;
import reactor.core.publisher.Mono;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.codec.max-in-memory-size=13"})
@DirtiesContext
public class ModifyRequestBodyGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Test
    public void modifyRequestBody() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.modifyrequestbody.org"})).header("Content-Type", new String[]{"application/xml"})).body(BodyInserters.fromValue((Object)"request")).exchange().expectStatus().isEqualTo(HttpStatus.OK).expectBody().jsonPath("headers.Content-Type", new Object[0]).isEqualTo((Object)"application/json").jsonPath("data", new Object[0]).isEqualTo((Object)"modifyrequest");
    }

    @Test
    public void upstreamRequestBodyIsEmpty() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.modifyrequestbodyempty.org"})).header("Content-Type", new String[]{"application/json"})).exchange().expectStatus().isEqualTo(HttpStatus.OK).expectBody().jsonPath("headers.Content-Type", new Object[0]).isEqualTo((Object)"application/json").jsonPath("data", new Object[0]).isEqualTo((Object)"modifyrequest");
    }

    @Test
    public void modifyRequestBodyToLarge() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.modifyrequestbodyemptytolarge.org"})).header("Content-Type", new String[]{"application/xml"})).body(BodyInserters.fromValue((Object)"request")).exchange().expectStatus().isEqualTo(HttpStatus.INTERNAL_SERVER_ERROR).expectBody().jsonPath("message", new Object[0]).isEqualTo((Object)"Exceeded limit on max bytes to buffer : 13");
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test_modify_request_body", r -> r.order(-1).host(new String[]{"**.modifyrequestbody.org"}).filters(f -> f.modifyRequestBody(String.class, String.class, "application/json", (serverWebExchange, aVoid) -> Mono.just((Object)"modifyrequest"))).uri(this.uri)).route("test_modify_request_body_empty", r -> r.order(-1).host(new String[]{"**.modifyrequestbodyempty.org"}).filters(f -> f.modifyRequestBody(String.class, String.class, "application/json", (serverWebExchange, body) -> {
                if (body == null) {
                    return Mono.just((Object)"modifyrequest");
                }
                return Mono.just((Object)body.toUpperCase());
            })).uri(this.uri)).route("test_modify_request_body_to_large", r -> r.order(-1).host(new String[]{"**.modifyrequestbodyemptytolarge.org"}).filters(f -> f.modifyRequestBody(String.class, String.class, "application/json", (serverWebExchange, body) -> Mono.just((Object)"tolarge-tolarge-tolarge-tolarge-tolarge-tolarge-tolarge-tolarge-tolarge-tolarge-tolarge-tolarge-tolarge-tolarge-tolarge-tolarge"))).uri(this.uri)).build();
        }
    }
}

