/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.cloud.gateway.filter.headers.GRPCRequestHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class GRPCRequestHeadersFilterTest {
    @Test
    public void shouldIncludeTrailersHeaderIfGRPC() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost:8080/get", (Object[])new Object[0]).header("Content-Type", new String[]{"application/grpc"}).build();
        GRPCRequestHeadersFilter filter = new GRPCRequestHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((Map)headers).containsKeys((Object[])new String[]{"te"});
        Assertions.assertThat((String)headers.getFirst("te")).isEqualTo("trailers");
    }

    @Test
    public void shouldNotIncludeTrailersHeaderIfNotGRPC() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost:8080/get", (Object[])new Object[0]).header("Content-Type", new String[]{"application/json"}).build();
        GRPCRequestHeadersFilter filter = new GRPCRequestHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((Map)headers).doesNotContainKeys((Object[])new String[]{"te"});
    }
}

