/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;
import org.springframework.cloud.gateway.filter.headers.TransferEncodingNormalizationHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class TransferEncodingNormalizationHeadersFilterTests {
    @Test
    public void noTransferEncodingWithContentLength() {
        MockServerHttpRequest.BaseBuilder builder = MockServerHttpRequest.post((String)"http://localhost/post", (Object[])new Object[0]).header("Content-Length", new String[]{"6"});
        HttpHeaders headers = this.testFilter(MockServerWebExchange.from((MockServerHttpRequest.BaseBuilder)builder));
        ((MapAssert)Assertions.assertThat((Map)headers).containsKey((Object)"Content-Length")).doesNotContainKey((Object)"Transfer-Encoding");
    }

    @Test
    public void transferEncodingWithContentLength() {
        MockServerHttpRequest.BaseBuilder builder = ((MockServerHttpRequest.BodyBuilder)MockServerHttpRequest.post((String)"http://localhost/post", (Object[])new Object[0]).header("Content-Length", new String[]{"6"})).header("Transfer-Encoding", new String[]{"chunked"});
        HttpHeaders headers = this.testFilter(MockServerWebExchange.from((MockServerHttpRequest.BaseBuilder)builder));
        ((MapAssert)Assertions.assertThat((Map)headers).doesNotContainKey((Object)"Content-Length")).containsKey((Object)"Transfer-Encoding");
    }

    @Test
    public void transferEncodingCaseInsensitiveWithContentLength() {
        MockServerHttpRequest.BaseBuilder builder = ((MockServerHttpRequest.BodyBuilder)MockServerHttpRequest.post((String)"http://localhost/post", (Object[])new Object[0]).header("Content-Length", new String[]{"6"})).header("Transfer-Encoding", new String[]{"Chunked "});
        HttpHeaders headers = this.testFilter(MockServerWebExchange.from((MockServerHttpRequest.BaseBuilder)builder));
        ((MapAssert)Assertions.assertThat((Map)headers).doesNotContainKey((Object)"Content-Length")).containsKey((Object)"Transfer-Encoding");
    }

    private HttpHeaders testFilter(MockServerWebExchange exchange) {
        TransferEncodingNormalizationHeadersFilter filter = new TransferEncodingNormalizationHeadersFilter();
        return filter.filter(exchange.getRequest().getHeaders(), (ServerWebExchange)exchange);
    }
}

