/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import org.springframework.boot.test.system.OutputCaptureRule;
import org.springframework.cloud.gateway.config.GlobalCorsProperties;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.core.env.Environment;
import org.springframework.mock.env.MockEnvironment;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class RoutePredicateHandlerMappingTests {
    @Rule
    public OutputCaptureRule outputCapture = new OutputCaptureRule();

    @Test
    public void lookupRouteFromSyncPredicates() {
        Route routeFalse = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeFalse")).uri("http://localhost")).predicate(swe -> false).build();
        Route routeFail = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeFail")).uri("http://localhost")).predicate(swe -> {
            throw new IllegalStateException("boom");
        }).build();
        Route routeTrue = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeTrue")).uri("http://localhost")).predicate(swe -> true).build();
        RouteLocator routeLocator2 = () -> Flux.just((Object[])new Route[]{routeFalse, routeFail, routeTrue}).hide();
        RoutePredicateHandlerMapping mapping = new RoutePredicateHandlerMapping(null, routeLocator2, new GlobalCorsProperties(), (Environment)new MockEnvironment());
        Mono routeMono = mapping.lookupRoute((ServerWebExchange)Mockito.mock(ServerWebExchange.class));
        StepVerifier.create((Publisher)routeMono.map(Route::getId)).expectNext((Object)"routeTrue").verifyComplete();
        this.outputCapture.expect(Matchers.containsString((String)"Error applying predicate for route: routeFail"));
        this.outputCapture.expect(Matchers.containsString((String)"java.lang.IllegalStateException: boom"));
    }

    @Test
    public void lookupRouteFromAsyncPredicates() {
        Route routeFalse = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeFalse")).uri("http://localhost")).asyncPredicate(swe -> Mono.just((Object)false)).build();
        Route routeError = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeError")).uri("http://localhost")).asyncPredicate(swe -> Mono.error((Throwable)new IllegalStateException("boom1"))).build();
        Route routeFail = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeFail")).uri("http://localhost")).asyncPredicate(swe -> {
            throw new IllegalStateException("boom2");
        }).build();
        Route routeTrue = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("routeTrue")).uri("http://localhost")).asyncPredicate(swe -> Mono.just((Object)true)).build();
        RouteLocator routeLocator2 = () -> Flux.just((Object[])new Route[]{routeFalse, routeError, routeFail, routeTrue}).hide();
        RoutePredicateHandlerMapping mapping = new RoutePredicateHandlerMapping(null, routeLocator2, new GlobalCorsProperties(), (Environment)new MockEnvironment());
        Mono routeMono = mapping.lookupRoute((ServerWebExchange)Mockito.mock(ServerWebExchange.class));
        StepVerifier.create((Publisher)routeMono.map(Route::getId)).expectNext((Object)"routeTrue").verifyComplete();
        this.outputCapture.expect(Matchers.containsString((String)"Error applying predicate for route: routeError"));
        this.outputCapture.expect(Matchers.containsString((String)"java.lang.IllegalStateException: boom1"));
        this.outputCapture.expect(Matchers.containsString((String)"Error applying predicate for route: routeFail"));
        this.outputCapture.expect(Matchers.containsString((String)"java.lang.IllegalStateException: boom2"));
    }
}

