/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.handler.predicate.HostRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.PathRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.ReadBodyRoutePredicateFactory;
import org.springframework.cloud.gateway.route.Route;

public class GatewayPredicateVisitorTests {
    @Test
    public void asyncPredicateVisitVisitsEachNode() {
        PathRoutePredicateFactory pathRoutePredicateFactory = new PathRoutePredicateFactory();
        HostRoutePredicateFactory hostRoutePredicateFactory = new HostRoutePredicateFactory();
        ReadBodyRoutePredicateFactory readBodyRoutePredicateFactory1 = new ReadBodyRoutePredicateFactory();
        ReadBodyRoutePredicateFactory readBodyRoutePredicateFactory2 = new ReadBodyRoutePredicateFactory();
        AsyncPredicate predicate = AsyncPredicate.from((Predicate)pathRoutePredicateFactory.apply((PathRoutePredicateFactory.Config)pathRoutePredicateFactory.newConfig())).and(AsyncPredicate.from((Predicate)hostRoutePredicateFactory.apply((HostRoutePredicateFactory.Config)hostRoutePredicateFactory.newConfig()))).and(readBodyRoutePredicateFactory1.applyAsync((ReadBodyRoutePredicateFactory.Config)readBodyRoutePredicateFactory1.newConfig())).and(readBodyRoutePredicateFactory2.applyAsync((ReadBodyRoutePredicateFactory.Config)readBodyRoutePredicateFactory2.newConfig()));
        Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("git")).uri("http://myuri")).asyncPredicate(predicate).build();
        ArrayList configs = new ArrayList();
        route.getPredicate().accept(p -> configs.add(p.getConfig()));
        ((ListAssert)Assertions.assertThat(configs).hasSize(4)).hasExactlyElementsOfTypes(new Class[]{PathRoutePredicateFactory.Config.class, HostRoutePredicateFactory.Config.class, ReadBodyRoutePredicateFactory.Config.class, ReadBodyRoutePredicateFactory.Config.class});
    }

    @Test
    public void predicateVisitVisitsEachNode() {
        PathRoutePredicateFactory pathRoutePredicateFactory = new PathRoutePredicateFactory();
        HostRoutePredicateFactory hostRoutePredicateFactory = new HostRoutePredicateFactory();
        Predicate predicate = pathRoutePredicateFactory.apply((PathRoutePredicateFactory.Config)pathRoutePredicateFactory.newConfig()).and(hostRoutePredicateFactory.apply((HostRoutePredicateFactory.Config)hostRoutePredicateFactory.newConfig()));
        Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("git")).uri("http://myuri")).predicate(predicate).build();
        ArrayList configs = new ArrayList();
        route.getPredicate().accept(p -> configs.add(p.getConfig()));
        ((ListAssert)Assertions.assertThat(configs).hasSize(2)).hasExactlyElementsOfTypes(new Class[]{PathRoutePredicateFactory.Config.class, HostRoutePredicateFactory.Config.class});
    }
}

