/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RedisRouteDefinitionRepository;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.DynamicPropertySource;
import org.springframework.web.server.ServerWebExchange;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;
import reactor.core.publisher.Mono;

@SpringBootTest(properties={"debug=true", "logging.level.org.springframework.cloud.gateway=trace"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
@ActiveProfiles(value={"redis-route-repository"})
@Testcontainers
@Tag(value="DockerRequired")
public class RedisRouteDefinitionRepositoryTests {
    @Container
    public static GenericContainer redis = new GenericContainer("redis:5.0.14-alpine").withExposedPorts(new Integer[]{6379});
    @Autowired
    private RedisRouteDefinitionRepository redisRouteDefinitionRepository;

    @BeforeAll
    public static void startRedisContainer() {
        redis.start();
    }

    @DynamicPropertySource
    static void containerProperties(DynamicPropertyRegistry registry) {
        registry.add("spring.redis.host", () -> ((GenericContainer)redis).getContainerIpAddress());
        registry.add("spring.redis.port", () -> ((GenericContainer)redis).getFirstMappedPort());
    }

    @Test
    public void testAddRouteToRedis() {
        RouteDefinition testRouteDefinition = this.defaultTestRoute();
        this.redisRouteDefinitionRepository.save(Mono.just((Object)testRouteDefinition)).block();
        List routeDefinitions = (List)this.redisRouteDefinitionRepository.getRouteDefinitions().collectList().block();
        Assertions.assertThat((int)routeDefinitions.size()).isEqualTo(1);
        Assertions.assertThat(routeDefinitions.get(0)).isEqualTo((Object)testRouteDefinition);
    }

    @Test
    public void testRemoveRouteFromRedis() {
        RouteDefinition testRouteDefinition = this.defaultTestRoute();
        this.redisRouteDefinitionRepository.save(Mono.just((Object)testRouteDefinition)).block();
        List routeDefinitions = (List)this.redisRouteDefinitionRepository.getRouteDefinitions().collectList().block();
        String routeId = ((RouteDefinition)routeDefinitions.get(0)).getId();
        Assertions.assertThat((int)routeDefinitions.size()).isEqualTo(1);
        this.redisRouteDefinitionRepository.delete(Mono.just((Object)routeId)).block();
        Assertions.assertThat((int)((List)this.redisRouteDefinitionRepository.getRouteDefinitions().collectList().block()).size()).isEqualTo(0);
    }

    @NotNull
    private RouteDefinition defaultTestRoute() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setId("test-route");
        testRouteDefinition.setUri(URI.create("http://example.org"));
        FilterDefinition prefixPathFilterDefinition = new FilterDefinition("PrefixPath=/test-path");
        FilterDefinition redirectToFilterDefinition = new FilterDefinition("RemoveResponseHeader=Sensitive-Header");
        FilterDefinition testFilterDefinition = new FilterDefinition();
        testFilterDefinition.setName("Test");
        testRouteDefinition.setFilters(Arrays.asList(prefixPathFilterDefinition, redirectToFilterDefinition, testFilterDefinition));
        PredicateDefinition hostRoutePredicateDefinition = new PredicateDefinition("Host=myhost.org");
        PredicateDefinition methodRoutePredicateDefinition = new PredicateDefinition("Method=GET");
        PredicateDefinition testPredicateDefinition = new PredicateDefinition("Test=value");
        testRouteDefinition.setPredicates(Arrays.asList(hostRoutePredicateDefinition, methodRoutePredicateDefinition, testPredicateDefinition));
        return testRouteDefinition;
    }

    public static class TestRoutePredicateFactory
    extends AbstractRoutePredicateFactory<Object> {
        public TestRoutePredicateFactory() {
            super(Object.class);
        }

        public Predicate<ServerWebExchange> apply(Object config) {
            return exchange -> true;
        }
    }

    public static class TestFilterGatewayFilterFactory
    extends TestGatewayFilterFactory {
    }

    public static class TestGatewayFilterFactory
    extends AbstractGatewayFilterFactory<Object> {
        public GatewayFilter apply(Object config) {
            return (exchange, chain) -> chain.filter(exchange);
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    public static class TestConfig {
        @Bean
        TestGatewayFilterFactory testGatewayFilterFactory() {
            return new TestGatewayFilterFactory();
        }

        @Bean
        TestFilterGatewayFilterFactory testFilterGatewayFilterFactory() {
            return new TestFilterGatewayFilterFactory();
        }

        @Bean
        TestRoutePredicateFactory testRoutePredicateFactory() {
            return new TestRoutePredicateFactory();
        }
    }
}

