/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinitionMetrics;
import reactor.core.publisher.Flux;

@ExtendWith(value={MockitoExtension.class})
class RouteDefinitionMetricsTests {
    @Mock
    private MeterRegistry registry;
    @Mock
    private RouteDefinitionLocator routeDefinitionLocator;
    private RouteDefinitionMetrics routeDefinitionMetrics;
    private AtomicInteger routeDefinitionCount;

    RouteDefinitionMetricsTests() {
    }

    @BeforeEach
    void setUp() {
        this.routeDefinitionCount = new AtomicInteger(0);
        Mockito.when((Object)this.registry.gauge((String)ArgumentMatchers.any(String.class), (Number)ArgumentMatchers.any(AtomicInteger.class))).thenReturn((Object)this.routeDefinitionCount);
        this.routeDefinitionMetrics = new RouteDefinitionMetrics(this.registry, this.routeDefinitionLocator, "prefix.");
    }

    @Test
    void metricsPrefix() {
        AssertionsForClassTypes.assertThat((String)this.routeDefinitionMetrics.getMetricsPrefix()).isEqualTo("prefix");
    }

    @Test
    void shouldReportOneRoute() {
        List<RouteDefinition> oneRoute = Collections.singletonList(new RouteDefinition());
        Mockito.when((Object)this.routeDefinitionLocator.getRouteDefinitions()).thenReturn((Object)Flux.fromStream(oneRoute.stream()));
        RefreshRoutesEvent refreshRoutesEvent = new RefreshRoutesEvent((Object)this);
        this.routeDefinitionMetrics.onApplicationEvent(refreshRoutesEvent);
        AssertionsForClassTypes.assertThat((int)this.routeDefinitionCount.get()).isEqualTo(1);
    }

    @Test
    void shouldReportMultipleRoutes() {
        List<RouteDefinition> multipleRoutes = Arrays.asList(new RouteDefinition(), new RouteDefinition(), new RouteDefinition(), new RouteDefinition(), new RouteDefinition());
        Mockito.when((Object)this.routeDefinitionLocator.getRouteDefinitions()).thenReturn((Object)Flux.fromStream(multipleRoutes.stream()));
        RefreshRoutesEvent refreshRoutesEvent = new RefreshRoutesEvent((Object)this);
        this.routeDefinitionMetrics.onApplicationEvent(refreshRoutesEvent);
        AssertionsForClassTypes.assertThat((int)this.routeDefinitionCount.get()).isEqualTo(5);
    }

    @Test
    void shouldReportZeroIfNoRoutes() {
        Object[] zeroRoutes = new RouteDefinition[]{};
        Mockito.when((Object)this.routeDefinitionLocator.getRouteDefinitions()).thenReturn((Object)Flux.fromArray((Object[])zeroRoutes));
        RefreshRoutesEvent refreshRoutesEvent = new RefreshRoutesEvent((Object)this);
        this.routeDefinitionMetrics.onApplicationEvent(refreshRoutesEvent);
        AssertionsForClassTypes.assertThat((int)this.routeDefinitionCount.get()).isEqualTo(0);
    }
}

