/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Maps;
import org.junit.Test;
import org.springframework.cloud.gateway.route.RouteDefinition;

public class RouteDefinitionTest {
    @Test
    public void addRouteDefinitionKeepsExistingMetadata() {
        Map originalMetadata = Maps.newHashMap((Object)"key", (Object)"value");
        Map newMetadata = Maps.newHashMap((Object)"key2", (Object)"value2");
        RouteDefinition routeDefinition = new RouteDefinition();
        routeDefinition.setMetadata(originalMetadata);
        routeDefinition.getMetadata().putAll(newMetadata);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)routeDefinition.getMetadata()).hasSize(2)).containsAllEntriesOf(originalMetadata)).containsAllEntriesOf(newMetadata);
    }

    @Test
    public void setRouteDefinitionReplacesExistingMetadata() {
        Map originalMetadata = Maps.newHashMap((Object)"key", (Object)"value");
        Map newMetadata = Maps.newHashMap((Object)"key2", (Object)"value2");
        RouteDefinition routeDefinition = new RouteDefinition();
        routeDefinition.setMetadata(originalMetadata);
        routeDefinition.setMetadata(newMetadata);
        Assertions.assertThat((Map)routeDefinition.getMetadata()).isEqualTo((Object)newMetadata);
    }

    @Test
    public void addSingleMetadataEntryKeepsOriginalMetadata() {
        Map originalMetadata = Maps.newHashMap((Object)"key", (Object)"value");
        RouteDefinition routeDefinition = new RouteDefinition();
        routeDefinition.setMetadata(originalMetadata);
        routeDefinition.getMetadata().put("key2", "value2");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)routeDefinition.getMetadata()).hasSize(2)).containsAllEntriesOf(originalMetadata)).containsEntry((Object)"key2", (Object)"value2");
    }
}

