/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.event.ParentHeartbeatEvent;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.route.RouteRefreshListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.ContextRefreshedEvent;

public class RouteRefreshListenerTests {
    @Test
    public void onContextRefreshedEventManagement() {
        ApplicationEventPublisher publisher = (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class);
        RouteRefreshListener listener = new RouteRefreshListener(publisher);
        WebServerApplicationContext applicationContext = (WebServerApplicationContext)Mockito.mock(WebServerApplicationContext.class);
        Mockito.when((Object)applicationContext.getServerNamespace()).thenReturn((Object)"management");
        listener.onApplicationEvent((ApplicationEvent)new ContextRefreshedEvent((ApplicationContext)applicationContext));
        Mockito.verifyNoInteractions((Object[])new Object[]{publisher});
    }

    @Test
    public void onContextRefreshedEvent() {
        ApplicationEventPublisher publisher = (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class);
        RouteRefreshListener listener = new RouteRefreshListener(publisher);
        listener.onApplicationEvent((ApplicationEvent)new ContextRefreshedEvent((ApplicationContext)Mockito.mock(ApplicationContext.class)));
        ((ApplicationEventPublisher)Mockito.verify((Object)publisher)).publishEvent((ApplicationEvent)ArgumentMatchers.any(RefreshRoutesEvent.class));
    }

    @Test
    public void onInstanceRegisteredEvent() {
        ApplicationEventPublisher publisher = (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class);
        RouteRefreshListener listener = new RouteRefreshListener(publisher);
        listener.onApplicationEvent((ApplicationEvent)new InstanceRegisteredEvent((Object)this, new Object()));
        ((ApplicationEventPublisher)Mockito.verify((Object)publisher)).publishEvent((ApplicationEvent)ArgumentMatchers.any(RefreshRoutesEvent.class));
    }

    @Test
    public void onHeartbeatEvent() {
        ApplicationEventPublisher publisher = (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class);
        RouteRefreshListener listener = new RouteRefreshListener(publisher);
        listener.onApplicationEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)1L));
        listener.onApplicationEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)1L));
        listener.onApplicationEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)2L));
        ((ApplicationEventPublisher)Mockito.verify((Object)publisher, (VerificationMode)Mockito.times((int)2))).publishEvent((ApplicationEvent)ArgumentMatchers.any(RefreshRoutesEvent.class));
    }

    @Test
    public void onParentHeartbeatEvent() {
        ApplicationEventPublisher publisher = (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class);
        RouteRefreshListener listener = new RouteRefreshListener(publisher);
        listener.onApplicationEvent((ApplicationEvent)new ParentHeartbeatEvent((Object)this, (Object)1L));
        listener.onApplicationEvent((ApplicationEvent)new ParentHeartbeatEvent((Object)this, (Object)1L));
        listener.onApplicationEvent((ApplicationEvent)new ParentHeartbeatEvent((Object)this, (Object)2L));
        ((ApplicationEventPublisher)Mockito.verify((Object)publisher, (VerificationMode)Mockito.times((int)2))).publishEvent((ApplicationEvent)ArgumentMatchers.any(RefreshRoutesEvent.class));
    }
}

