/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.util.Collections;
import java.util.Map;
import javax.validation.constraints.Max;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.context.properties.bind.BindException;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.validation.MessageInterpolatorFactory;
import org.springframework.cloud.gateway.support.ConfigurationService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

public class ConfigurationServiceTests {
    @Test
    public void validationOnCreateWorks() {
        Map<String, Integer> map = Collections.singletonMap("config.value", 11);
        Assert.assertThrows(BindException.class, () -> {
            ValidatedConfig cfr_ignored_0 = (ValidatedConfig)ConfigurationService.bindOrCreate((Bindable)Bindable.of(ValidatedConfig.class), (Map)map, (String)"config", (Validator)this.getValidator(), null);
        });
    }

    @Test
    public void createWorks() {
        Map<String, Integer> map = Collections.singletonMap("config.value", 9);
        ValidatedConfig config = (ValidatedConfig)ConfigurationService.bindOrCreate((Bindable)Bindable.of(ValidatedConfig.class), map, (String)"config", (Validator)this.getValidator(), null);
        ((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).extracting(ValidatedConfig::getValue).isEqualTo((Object)9);
    }

    @Test
    public void validationOnBindWorks() {
        Map<String, Integer> map = Collections.singletonMap("config.value", 11);
        ValidatedConfig config = new ValidatedConfig();
        Assert.assertThrows(BindException.class, () -> {
            ValidatedConfig cfr_ignored_0 = (ValidatedConfig)ConfigurationService.bindOrCreate((Bindable)Bindable.ofInstance((Object)config), (Map)map, (String)"config", (Validator)this.getValidator(), null);
        });
    }

    @Test
    public void bindWorks() {
        Map<String, Integer> map = Collections.singletonMap("config.value", 9);
        ValidatedConfig config = new ValidatedConfig();
        ConfigurationService.bindOrCreate((Bindable)Bindable.ofInstance((Object)config), map, (String)"config", (Validator)this.getValidator(), null);
        ((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).extracting(ValidatedConfig::getValue).isEqualTo((Object)9);
    }

    LocalValidatorFactoryBean getValidator() {
        GenericApplicationContext context = new GenericApplicationContext();
        context.refresh();
        LocalValidatorFactoryBean validator = new LocalValidatorFactoryBean();
        validator.setApplicationContext((ApplicationContext)context);
        validator.setMessageInterpolator(new MessageInterpolatorFactory().getObject());
        validator.afterPropertiesSet();
        return validator;
    }

    public static class ValidatedConfig {
        @Max(value=10L)
        private @Max(value=10L) int value;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

