/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support.tagsprovider;

import io.micrometer.core.instrument.Tags;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayRouteTagsProvider;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class GatewayRouteTagsProviderTests {
    private final GatewayRouteTagsProvider tagsProvider = new GatewayRouteTagsProvider();
    private static final String ROUTE_URI = "http://gatewaytagsprovider.org:80";
    private static final String ROUTE_ID = "test-route";
    private static final Route ROUTE = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("test-route")).uri("http://gatewaytagsprovider.org:80")).predicate(swe -> true).build();
    private static final Tags DEFAULT_TAGS = Tags.of((String[])new String[]{"routeId", "test-route", "routeUri", "http://gatewaytagsprovider.org:80"});

    @Test
    public void routeTags() {
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)ROUTE_URI, (Object[])new Object[0]).build());
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, ROUTE);
        Tags tags = this.tagsProvider.apply((ServerWebExchange)exchange);
        Assertions.assertThat((Iterable)tags).isEqualTo((Object)DEFAULT_TAGS);
    }

    @Test
    public void emptyRoute() {
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)ROUTE_URI, (Object[])new Object[0]).build());
        Tags tags = this.tagsProvider.apply((ServerWebExchange)exchange);
        Assertions.assertThat((Iterable)tags).isEqualTo((Object)Tags.empty());
    }
}

