/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.context.annotation.Bean;

public class RouteConstructionIntegrationTests {
    @Test
    public void routesWithVerificationShouldFail() {
        Assertions.assertThatThrownBy(() -> new SpringApplicationBuilder(new Class[]{TestConfig.class}).profiles(new String[]{"verification-route"}).run(new String[0])).hasMessageContaining("Stop right now!");
    }

    public static class TestFilterGatewayFilterFactory
    extends AbstractGatewayFilterFactory<Config> {
        public TestFilterGatewayFilterFactory() {
            super(Config.class);
        }

        public GatewayFilter apply(Config config) {
            throw new AssertionError((Object)"Stop right now!");
        }

        public static class Config {
            private String arg1;

            public String getArg1() {
                return this.arg1;
            }

            public void setArg1(String arg1) {
                this.arg1 = arg1;
            }
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    public static class TestConfig {
        @Bean
        public TestFilterGatewayFilterFactory testFilterGatewayFilterFactory() {
            return new TestFilterGatewayFilterFactory();
        }
    }
}

