/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.cors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.cloud.gateway.config.GlobalCorsProperties;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.context.ApplicationListener;
import org.springframework.web.cors.CorsConfiguration;

public class CorsGatewayFilterApplicationListener
implements ApplicationListener<RefreshRoutesEvent> {
    private final GlobalCorsProperties globalCorsProperties;
    private final RoutePredicateHandlerMapping routePredicateHandlerMapping;
    private final RouteDefinitionLocator routeDefinitionLocator;
    private static final String PATH_PREDICATE_NAME = "Path";
    private static final String METADATA_KEY = "cors";
    private static final String ALL_PATHS = "/**";

    public CorsGatewayFilterApplicationListener(GlobalCorsProperties globalCorsProperties, RoutePredicateHandlerMapping routePredicateHandlerMapping, RouteDefinitionLocator routeDefinitionLocator) {
        this.globalCorsProperties = globalCorsProperties;
        this.routePredicateHandlerMapping = routePredicateHandlerMapping;
        this.routeDefinitionLocator = routeDefinitionLocator;
    }

    public void onApplicationEvent(RefreshRoutesEvent event) {
        this.routeDefinitionLocator.getRouteDefinitions().collectList().subscribe(routeDefinitions -> {
            HashMap<String, CorsConfiguration> corsConfigurations = new HashMap<String, CorsConfiguration>(this.globalCorsProperties.getCorsConfigurations());
            routeDefinitions.forEach(routeDefinition -> {
                Optional<CorsConfiguration> corsConfiguration = this.getCorsConfiguration((RouteDefinition)routeDefinition);
                corsConfiguration.ifPresent(configuration -> {
                    String pathPredicate = this.getPathPredicate((RouteDefinition)routeDefinition);
                    corsConfigurations.put(pathPredicate, (CorsConfiguration)configuration);
                });
            });
            this.routePredicateHandlerMapping.setCorsConfigurations(corsConfigurations);
        });
    }

    private String getPathPredicate(RouteDefinition routeDefinition) {
        return routeDefinition.getPredicates().stream().filter(predicate -> PATH_PREDICATE_NAME.equals(predicate.getName())).findFirst().flatMap(predicate -> predicate.getArgs().values().stream().findFirst()).orElse(ALL_PATHS);
    }

    private Optional<CorsConfiguration> getCorsConfiguration(RouteDefinition routeDefinition) {
        Map corsMetadata = (Map)routeDefinition.getMetadata().get(METADATA_KEY);
        if (corsMetadata != null) {
            CorsConfiguration corsConfiguration = new CorsConfiguration();
            this.findValue(corsMetadata, "allowCredentials").ifPresent(value -> corsConfiguration.setAllowCredentials((Boolean)value));
            this.findValue(corsMetadata, "allowedHeaders").ifPresent(value -> corsConfiguration.setAllowedHeaders(this.asList(value)));
            this.findValue(corsMetadata, "allowedMethods").ifPresent(value -> corsConfiguration.setAllowedMethods(this.asList(value)));
            this.findValue(corsMetadata, "allowedOriginPatterns").ifPresent(value -> corsConfiguration.setAllowedOriginPatterns(this.asList(value)));
            this.findValue(corsMetadata, "allowedOrigins").ifPresent(value -> corsConfiguration.setAllowedOrigins(this.asList(value)));
            this.findValue(corsMetadata, "exposedHeaders").ifPresent(value -> corsConfiguration.setExposedHeaders(this.asList(value)));
            this.findValue(corsMetadata, "maxAge").ifPresent(value -> corsConfiguration.setMaxAge(this.asLong(value)));
            return Optional.of(corsConfiguration);
        }
        return Optional.empty();
    }

    private Optional<Object> findValue(Map<String, Object> metadata, String key) {
        Object value = metadata.get(key);
        return Optional.ofNullable(value);
    }

    private List<String> asList(Object value) {
        if (value instanceof String) {
            return Arrays.asList((String)value);
        }
        if (value instanceof Map) {
            return new ArrayList<String>(((Map)value).values());
        }
        return (List)value;
    }

    private Long asLong(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        return (Long)value;
    }
}

